/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.highlighter;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.Highlighter;

public class SyntaxHighlighter
implements Highlighter {
    public static final String NAME = "SyntaxHighlighter";

    public boolean containsHighlightCodeBlock(String content) {
        return StringUtils.contains((String)content, (String)"<pre class='brush:") || StringUtils.contains((String)content, (String)"<pre class=\"brush:");
    }

    public String getHighlighterName() {
        return NAME;
    }

    public void highlight(StringBuilder out, List<String> lines, String meta) {
        out.append("<pre");
        if (StringUtils.isNotBlank((String)meta)) {
            out.append(" class='brush:" + meta + "'");
        }
        out.append(">");
        for (String line : lines) {
            block6: for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                switch (c) {
                    case '&': {
                        out.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        out.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        out.append("&gt;");
                        continue block6;
                    }
                    default: {
                        out.append(c);
                    }
                }
            }
            out.append('\n');
        }
        out.append("</pre>");
    }
}

