/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.opoo.press.Convertible;
import org.opoo.press.Renderer;
import org.opoo.press.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConvertible
implements Convertible {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public abstract String getUrl();

    public abstract String getContent();

    public abstract void setContent(String var1);

    public abstract String getOutputFileExtension();

    public abstract String getLayout();

    protected abstract Renderer getRenderer();

    protected abstract void mergeRootMap(Map<String, Object> var1);

    public abstract Source getSource();

    public void render(Map<String, Object> rootMap) {
        Renderer renderer = this.getRenderer();
        boolean isContentRenderRequired = renderer.isRenderRequired(this.getContent());
        boolean isValidLayout = renderer.isValidLayout(this.getLayout());
        if (!isValidLayout && !isContentRenderRequired) {
            this.log.debug("Layout is nil and content is plain text, skip render file: {}", (Object)this.getSource().getSourceEntry().getFile());
            return;
        }
        rootMap = new HashMap<String, Object>(rootMap);
        this.mergeRootMap(rootMap);
        if (!isContentRenderRequired) {
            rootMap.put("content", this.getContent());
        }
        String name = isContentRenderRequired ? renderer.prepareWorkingTemplate(this.getLayout(), isValidLayout, this.getContent(), isContentRenderRequired, this.getSource().getSourceEntry()) : renderer.getLayoutWorkingTemplate(this.getLayout());
        String output = renderer.render(name, rootMap);
        this.setContent(output);
    }

    protected String getUrlForOutputFile() {
        return this.getUrl();
    }

    public File getOutputFile(File dest) {
        String url = this.getUrlForOutputFile();
        if (url.endsWith("/")) {
            url = url + "index" + this.getOutputFileExtension();
        }
        File target = new File(dest, url);
        return target;
    }

    public void write(File dest) {
        File file = this.getOutputFile(dest);
        try {
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            this.log.debug("Writing file to {} [{}]", (Object)file, (Object)this.getUrl());
            FileUtils.write((File)file, (CharSequence)this.getContent(), (String)"UTF-8");
        }
        catch (IOException e) {
            this.log.error("Write file error: {}", (Object)file, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

