/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.util.ArrayList;
import java.util.List;
import org.opoo.press.Category;
import org.opoo.press.Post;
import org.opoo.press.Site;
import org.opoo.util.URLUtils;

public class CategoryImpl
implements Category {
    private Category parent;
    private List<Category> children = new ArrayList<Category>();
    private String nicename;
    private String name;
    private List<Post> posts = new ArrayList<Post>();
    private String path;
    private String title;
    private String url;

    public CategoryImpl(String nicename, String name, Site site) {
        this(nicename, name, null, site);
    }

    public CategoryImpl(String nicename, String name, Category parent, Site site) {
        this.parent = parent;
        this.nicename = nicename;
        this.name = name;
        this.init(site);
    }

    public CategoryImpl(String url, String path, String title, String nicename, String name, Category parent) {
        this.parent = parent;
        this.nicename = nicename;
        this.name = name;
        this.url = url;
        this.path = path;
        this.title = title;
    }

    private void init(Site site) {
        boolean categoryTree;
        if (this.parent != null) {
            this.parent.getChildren().add(this);
        }
        this.path = (categoryTree = ((Boolean)site.getConfig().get("category_tree", (Object)true)).booleanValue()) && this.parent != null ? this.parent.getPath() + "." + this.nicename : this.nicename;
        if (categoryTree && this.parent != null) {
            this.url = this.parent.getUrl() + URLUtils.encodeURL(this.nicename) + "/";
        } else {
            String categoryDir = (String)site.getConfig().get("category_dir", (Object)"");
            this.url = categoryDir + "/" + URLUtils.encodeURL(this.nicename) + "/";
        }
        this.title = categoryTree && this.parent != null ? this.parent.getTitle() + " &#8250; " + this.name : this.name;
    }

    public Category getParent() {
        return this.parent;
    }

    public List<Category> getChildren() {
        return this.children;
    }

    public String getNicename() {
        return this.nicename;
    }

    public String getName() {
        return this.name;
    }

    public List<Post> getPosts() {
        return this.posts;
    }

    public boolean isNameOrNicename(String nameOrNicename) {
        if (nameOrNicename.equalsIgnoreCase(this.getNicename())) {
            return true;
        }
        return nameOrNicename.equals(this.getName());
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public int getPostSize() {
        return this.posts.size();
    }
}

