/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.opoo.press.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class ConfigImpl
extends HashMap<String, Object>
implements Config {
    private static final long serialVersionUID = 2347499217663917623L;
    private static final Logger log = LoggerFactory.getLogger(ConfigImpl.class);
    public static final String DEFAULT_NEW_POST_TEMPLATE = "new_post.ftl";
    public static final String DEFAULT_NEW_PAGE_TEMPLATE = "new_page.ftl";
    public static final String DEFAULT_POSTS_FOLDER = "posts";
    public static final String DEFAULT_PAGES_FOLDER = "pages";
    public static final String DEFAULT_ASSETS_FOLDER = "assets";
    public static final String DEFAULT_NEW_POST_FILE = "posts/${year}-${month}-${day}-${name}.${format}";
    public static final String DEFAULT_NEW_PAGE_FILE = "pages/${name}.${format}";
    public static final String DEFAULT_PERMALINK_STYLE = "/article/${year}/${month}/${name}.html";
    public static final FileFilter DEFAULT_CONFIG_FILES_FILTER = new DefaultConfigFilesFilter();
    private static ObjectMapper objectMapper;
    private Map<String, Object> overrideConfig;
    private File[] configFiles;
    private final File base;
    private boolean useDefaultConfigFiles = false;

    public ConfigImpl(File base, Map<String, Object> override) {
        this.base = base;
        this.initDefaultConfig();
        if (override != null) {
            this.putAll(override);
            this.overrideConfig = override;
        }
        long start = System.currentTimeMillis();
        this.configFiles = this.resolveConfigFiles(base, override);
        Arrays.sort(this.configFiles, new ConfigFileComparator());
        this.loadConfigFromFiles(this.configFiles);
        log.debug("Config files loaded in {} ms.", (Object)(System.currentTimeMillis() - start));
    }

    private void initDefaultConfig() {
        this.put("opoopress", ConfigImpl.defaultOpooPressOptions());
        this.put("root", "");
        this.put("asset_dirs", Arrays.asList(DEFAULT_ASSETS_FOLDER));
        this.put("source_dirs", Arrays.asList(DEFAULT_PAGES_FOLDER, DEFAULT_POSTS_FOLDER));
        this.put("plugin_dir", "plugins");
        this.put("dest_dir", "target/public");
        this.put("work_dir", "target/work");
        this.put("permalink", DEFAULT_PERMALINK_STYLE);
        this.put("permalink_label", "&infin;");
        this.put("category_dir", "/category");
        this.put("tag_dir", "/tag");
        this.put("excerpt_separator", "<!--more-->");
        this.put("paginate", 10);
        this.put("recent_posts", 5);
        this.put("related_posts", 5);
    }

    public static Map<String, Object> defaultOpooPressOptions() {
        String version;
        HashMap<String, Object> options = new HashMap<String, Object>();
        Package pkg = ConfigImpl.class.getPackage();
        String string = version = pkg != null ? pkg.getSpecificationVersion() : null;
        if (StringUtils.isBlank((String)version)) {
            version = "unkown_version";
        }
        options.put("version", version);
        options.put("name", "OpooPress");
        return options;
    }

    private void loadConfigFromFiles(File[] configFiles) {
        for (File file : configFiles) {
            log.info("Loading config from {}", (Object)file);
            this.loadConfigFromFile(file);
        }
    }

    private void loadConfigFromFile(File file) {
        String name = file.getName();
        FileInputStream inputStream = null;
        Map map = null;
        try {
            inputStream = FileUtils.openInputStream((File)file);
            if (FilenameUtils.isExtension((String)name, (String)"json")) {
                if (objectMapper == null) {
                    objectMapper = new ObjectMapper();
                }
                map = (Map)objectMapper.readValue((InputStream)inputStream, Map.class);
            } else {
                map = (Map)new Yaml().loadAs((InputStream)inputStream, Map.class);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (map != null) {
            log.debug("Config loaded: {}", (Object)map);
            this.putAll(map);
        }
    }

    private File[] resolveConfigFiles(File base, Map<String, Object> override) {
        String configFilesString;
        if (override != null && StringUtils.isNotBlank((String)(configFilesString = (String)override.remove("config")))) {
            log.info("Using config files: {}", (Object)configFilesString);
            String[] strings = StringUtils.split((String)configFilesString, (char)',');
            File[] files = new File[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                files[i] = new File(base, strings[i]);
            }
            return files;
        }
        this.useDefaultConfigFiles = true;
        return base.listFiles(DEFAULT_CONFIG_FILES_FILTER);
    }

    Map<String, Object> getOverrideConfig() {
        return this.overrideConfig;
    }

    public File[] getConfigFiles() {
        return this.configFiles;
    }

    public <T> T get(String name) {
        return (T)super.get(name);
    }

    public <T> T get(String name, T defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return this.get(name);
    }

    public File getBasedir() {
        return this.base;
    }

    public boolean useDefaultConfigFiles() {
        return this.useDefaultConfigFiles;
    }

    public static class ConfigFileComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            String name2;
            String name1 = o1.getName();
            if (name1.equals(name2 = o2.getName())) {
                return 0;
            }
            int delta = this.getIndex(name1) - this.getIndex(name2);
            if (delta != 0) {
                return delta;
            }
            name1 = FilenameUtils.removeExtension((String)name1);
            name2 = FilenameUtils.removeExtension((String)name2);
            return name1.compareTo(name2);
        }

        private int getIndex(String name) {
            if (name.endsWith(".yml")) {
                return 1;
            }
            if (name.endsWith(".yaml")) {
                return 2;
            }
            if (name.endsWith(".json")) {
                return 3;
            }
            return Integer.MAX_VALUE;
        }
    }

    private static class DefaultConfigFilesFilter
    implements FileFilter {
        static final String[] ACCEPTABLE_EXTENSIONS = new String[]{"yml", "yaml", "json"};

        private DefaultConfigFilesFilter() {
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return FilenameUtils.getBaseName((String)name).startsWith("config") && FilenameUtils.isExtension((String)name, (String[])ACCEPTABLE_EXTENSIONS) && file.canRead();
        }
    }
}

