/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.ConfigAware;
import org.opoo.press.Converter;
import org.opoo.press.Factory;
import org.opoo.press.Generator;
import org.opoo.press.Highlighter;
import org.opoo.press.Named;
import org.opoo.press.Ordered;
import org.opoo.press.Plugin;
import org.opoo.press.PluginManager;
import org.opoo.press.Processor;
import org.opoo.press.Registry;
import org.opoo.press.RelatedPostsFinder;
import org.opoo.press.Renderer;
import org.opoo.press.ResourceBuilder;
import org.opoo.press.Site;
import org.opoo.press.SiteAware;
import org.opoo.press.SlugHelper;
import org.opoo.press.Source;
import org.opoo.press.SourceEntryLoader;
import org.opoo.press.SourceManager;
import org.opoo.press.SourceParser;
import org.opoo.press.highlighter.SyntaxHighlighter;
import org.opoo.press.impl.AbstractFactory;
import org.opoo.press.impl.FreeMarkerRenderer;
import org.opoo.press.impl.NoOpRelatedPostsFinder;
import org.opoo.press.slug.DefaultSlugHelper;
import org.opoo.press.source.SourceEntryLoaderImpl;
import org.opoo.press.source.SourceManagerImpl;
import org.opoo.press.source.SourceParserImpl;
import org.opoo.press.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class FactoryImpl
extends AbstractFactory
implements Factory,
PluginManager,
SiteAware {
    private static final Logger log = LoggerFactory.getLogger(FactoryImpl.class);
    private Site site;
    private Map<String, Object> configuration = new LinkedHashMap<String, Object>();
    private SourceEntryLoader sourceEntryLoader;
    private SourceParser sourceParser;
    private SourceManager sourceManager;
    private Highlighter highlighter;
    private SlugHelper slugHelper;
    private RelatedPostsFinder relatedPostsFinder;
    private List<Converter> converters;
    private List<Generator> generators;
    private List<Processor> processors;
    private List<Plugin> plugins;
    private Map<String, String> resourceBuilderClassNames;
    private Map<Class, List> listMap = new HashMap<Class, List>();
    private Map<Class, Map> mapMap = new HashMap<Class, Map>();

    public void setSite(Site site) {
        this.site = site;
        InputStream is = Site.class.getResourceAsStream("/factory.yml");
        this.addConfiguration(is);
        File themeDir = site.getTheme().getPath();
        File factoryFile = new File(themeDir, "factory.yml");
        this.addConfiguration(factoryFile);
        File basedir = site.getBasedir();
        factoryFile = new File(basedir, "factory.yml");
        this.addConfiguration(factoryFile);
        this.initializePlugins();
    }

    void addConfiguration(InputStream is) {
        if (is != null) {
            Map map = (Map)new Yaml().loadAs(is, Map.class);
            this.configuration.putAll(map);
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    void addConfiguration(File factoryFile) {
        if (factoryFile != null && factoryFile.exists()) {
            try {
                this.addConfiguration(new FileInputStream(factoryFile));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public SourceEntryLoader getSourceEntryLoader() {
        if (this.sourceEntryLoader == null) {
            this.sourceEntryLoader = this.instantiate(SourceEntryLoader.class);
            if (this.sourceEntryLoader == null) {
                this.sourceEntryLoader = new SourceEntryLoaderImpl();
            }
        }
        return this.sourceEntryLoader;
    }

    public SourceParser getSourceParser() {
        if (this.sourceParser == null) {
            this.sourceParser = this.instantiate(SourceParser.class);
            if (this.sourceParser == null) {
                this.sourceParser = new SourceParserImpl();
            }
        }
        return this.sourceParser;
    }

    public SourceManager getSourceManager() {
        if (this.sourceManager == null) {
            this.sourceManager = this.instantiate(SourceManager.class);
            if (this.sourceManager == null) {
                this.sourceManager = new SourceManagerImpl();
            }
        }
        return this.sourceManager;
    }

    public Highlighter getHighlighter() {
        if (this.highlighter == null) {
            this.highlighter = this.instantiate(Highlighter.class);
            if (this.highlighter == null) {
                this.highlighter = new SyntaxHighlighter();
            }
        }
        return this.highlighter;
    }

    public SlugHelper getSlugHelper() {
        if (this.slugHelper == null) {
            if (this.site.getLocale() != null) {
                String hint = this.site.getLocale().toString();
                String str = SlugHelper.class.getName() + "-" + hint;
                String className = (String)this.configuration.get(str);
                if (className != null) {
                    this.slugHelper = (SlugHelper)this.newInstance(className);
                }
            }
            if (this.slugHelper == null) {
                this.slugHelper = this.instantiate(SlugHelper.class);
            }
            if (this.slugHelper == null) {
                this.slugHelper = new DefaultSlugHelper();
            }
        }
        return this.slugHelper;
    }

    public RelatedPostsFinder getRelatedPostsFinder() {
        if (this.relatedPostsFinder == null) {
            this.relatedPostsFinder = this.instantiate(RelatedPostsFinder.class);
            if (this.relatedPostsFinder == null) {
                this.relatedPostsFinder = new NoOpRelatedPostsFinder();
            }
        }
        return this.relatedPostsFinder;
    }

    public List<Converter> getConverters() {
        if (this.converters == null) {
            this.converters = this.instantiateList(Converter.class);
            this.sort(this.converters);
        }
        return this.converters;
    }

    public List<Generator> getGenerators() {
        if (this.generators == null) {
            this.generators = this.instantiateList(Generator.class);
            this.sort(this.generators);
        }
        return this.generators;
    }

    public List<Processor> getProcessors() {
        if (this.processors == null) {
            this.processors = this.instantiateList(Processor.class);
            this.sort(this.processors);
        }
        return this.processors;
    }

    private void initializePlugins() {
        if (this.plugins == null) {
            log.debug("Initializing plugins");
            this.plugins = this.instantiateList(Plugin.class);
            for (Plugin plugin : this.plugins) {
                log.debug("Initializing plugin: {}", (Object)plugin.getClass().getName());
                plugin.initialize((Registry)this);
            }
        }
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public PluginManager getPluginManager() {
        return this;
    }

    public Renderer createRenderer(Site site) {
        String className = (String)site.getTheme().get("renderer");
        if (className != null) {
            Class clazz;
            try {
                clazz = ClassUtils.getClass((ClassLoader)site.getClassLoader(), (String)className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
            Constructor<?>[] constructors = clazz.getConstructors();
            Constructor<?> theConstructor = null;
            for (Constructor<?> constructor : constructors) {
                Class<?>[] types = constructor.getParameterTypes();
                if (types.length != 1 || !types[0].equals(Site.class)) continue;
                theConstructor = constructor;
                break;
            }
            try {
                if (theConstructor != null) {
                    return (Renderer)theConstructor.newInstance(site);
                }
                Renderer renderer = (Renderer)clazz.newInstance();
                if (renderer instanceof SiteAware) {
                    ((SiteAware)renderer).setSite(site);
                }
                if (renderer instanceof ConfigAware) {
                    ((ConfigAware)renderer).setConfig(site.getConfig());
                }
                return renderer;
            }
            catch (InstantiationException e) {
                throw new RuntimeException("error instance: " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("error instance: " + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("error instance: " + e.getTargetException(), e.getTargetException());
            }
        }
        return new FreeMarkerRenderer(site);
    }

    private Renderer newInstance(Class<Renderer> clazz, Site site) {
        try {
            Renderer renderer = clazz.newInstance();
            if (renderer instanceof SiteAware) {
                ((SiteAware)renderer).setSite(site);
            }
            if (renderer instanceof ConfigAware) {
                ((ConfigAware)renderer).setConfig(site.getConfig());
            }
            return renderer;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("error instance" + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("error instance" + e.getMessage(), e);
        }
    }

    public ResourceBuilder createResourceBuilder(String type) {
        String className;
        if (this.resourceBuilderClassNames == null) {
            this.resourceBuilderClassNames = (Map)this.configuration.get(ResourceBuilder.class.getName());
            if (this.resourceBuilderClassNames == null) {
                this.resourceBuilderClassNames = Collections.emptyMap();
            }
        }
        if ((className = this.resourceBuilderClassNames.get(type)) == null) {
            className = type;
        }
        return (ResourceBuilder)ClassUtils.newInstance(className, this.site.getClassLoader(), this.site, this.site.getConfig());
    }

    public <T> T instantiate(Class<T> clazz) {
        ServiceLoader<T> loader = ServiceLoader.load(clazz, this.site.getClassLoader());
        Iterator<T> iterator = loader.iterator();
        if (iterator.hasNext()) {
            return this.apply(iterator.next());
        }
        String className = (String)this.configuration.get(clazz.getName());
        if (StringUtils.isBlank((String)className) || "none".equalsIgnoreCase(className)) {
            return null;
        }
        return this.newInstance(className);
    }

    private <T> T apply(T t) {
        if (t instanceof SiteAware) {
            ((SiteAware)t).setSite(this.site);
        }
        if (t instanceof ConfigAware) {
            ((ConfigAware)t).setConfig(this.site.getConfig());
        }
        return t;
    }

    public <T> T newInstance(String className) {
        Object t = ClassUtils.newInstance(className, this.site.getClassLoader(), this.site, this.site.getConfig());
        return t;
    }

    public <T> List<T> instantiateList(Class<T> clazz) {
        Object classNames;
        ArrayList<T> list = new ArrayList<T>();
        ServiceLoader<T> loader = ServiceLoader.load(clazz, this.site.getClassLoader());
        for (T t : loader) {
            t = this.apply(t);
            log.debug("Load instance: {} => {}", (Object)clazz.getName(), (Object)t.getClass().getName());
            list.add(t);
        }
        Object o = this.configuration.get(clazz.getName());
        if (o instanceof List) {
            classNames = (List)o;
            if (!classNames.isEmpty()) {
                Iterator i$ = classNames.iterator();
                while (i$.hasNext()) {
                    String className = (String)i$.next();
                    T t = this.newInstance(className);
                    log.debug("Create instance: {} => {}", (Object)clazz.getName(), (Object)className);
                    list.add(t);
                }
            }
        } else if (o instanceof Map) {
            classNames = (Map)o;
            if (!classNames.isEmpty()) {
                for (Map.Entry entry : classNames.entrySet()) {
                    String name = (String)entry.getKey();
                    String className = (String)entry.getValue();
                    T t = this.newInstance(className);
                    log.debug("Create instance: {} => {}", (Object)clazz.getName(), (Object)className);
                    list.add(t);
                }
            }
        } else if (o != null) {
            log.warn("Configuration error: {} => {}", (Object)clazz.getName(), o);
        }
        return list;
    }

    public <T> Map<String, T> instantiateMap(Class<T> clazz) {
        Object classNames;
        HashMap<String, T> map = new HashMap<String, T>();
        ServiceLoader<T> loader = ServiceLoader.load(clazz, this.site.getClassLoader());
        for (T t : loader) {
            if (!(t instanceof Named)) continue;
            t = this.apply(t);
            log.debug("Load instance for '{}': {} => {}", new Object[]{((Named)t).getName(), clazz.getName(), t.getClass().getName()});
            map.put(((Named)t).getName(), t);
        }
        Object o = this.configuration.get(clazz.getName());
        if (o instanceof List) {
            classNames = (List)o;
            if (!classNames.isEmpty()) {
                Iterator i$ = classNames.iterator();
                while (i$.hasNext()) {
                    String className = (String)i$.next();
                    T t = this.newInstance(className);
                    if (!(t instanceof Named)) continue;
                    log.debug("Create instance for '{}': {} => {}", new Object[]{((Named)t).getName(), clazz.getName(), className});
                    map.put(((Named)t).getName(), t);
                }
            }
        } else if (o instanceof Map) {
            classNames = (Map)o;
            if (!classNames.isEmpty()) {
                for (Map.Entry entry : classNames.entrySet()) {
                    String name = (String)entry.getKey();
                    String className = (String)entry.getValue();
                    T t = this.newInstance(className);
                    log.debug("Create instance for '{}': {} => {}", new Object[]{name, clazz.getName(), className});
                    map.put(name, t);
                }
            }
        } else if (o != null) {
            log.warn("Configuration error: {} => {}", (Object)clazz.getName(), o);
        }
        return map;
    }

    private <T extends Ordered> void sort(List<T> list) {
        if (!list.isEmpty()) {
            Collections.sort(list, Ordered.COMPARATOR);
        }
    }

    public Registry registerConverter(Converter c) {
        this.getConverters();
        this.converters.add(c);
        this.sort(this.converters);
        return this;
    }

    public Registry registerGenerator(Generator g) {
        this.getGenerators();
        this.generators.add(g);
        this.sort(this.generators);
        return this;
    }

    public Registry registerProcessor(Processor processor) {
        this.getProcessors();
        this.processors.add(processor);
        this.sort(this.processors);
        return this;
    }

    public Converter getConverter(Source source) throws RuntimeException {
        this.getConverters();
        for (Converter c : this.converters) {
            if (!c.matches(source)) continue;
            return c;
        }
        throw new RuntimeException("No matched converter: " + source.getSourceEntry().getFile());
    }

    public <T> List<T> getObjectList(Class<T> clazz) {
        List<T> list = this.listMap.get(clazz);
        if (list == null) {
            list = this.instantiateList(clazz);
            this.listMap.put(clazz, list);
        }
        return list;
    }

    public <T> Registry register(Class<T> clazz, T instance) {
        this.getObjectList(clazz).add(instance);
        return this;
    }

    public <T> Map<String, T> getObjectMap(Class<T> clazz) {
        Map<String, T> map = this.mapMap.get(clazz);
        if (map == null) {
            map = this.instantiateMap(clazz);
            this.mapMap.put(clazz, map);
        }
        return map;
    }

    public <T> Registry register(Class<T> clazz, String name, T instance) {
        this.getObjectMap(clazz).put(name, instance);
        return this;
    }

    public <T> Registry register(Class<T> clazz, Named named) {
        return this.register(clazz, named.getName(), named);
    }

    public static Factory createInstance(Site site) {
        String factoryClassName = (String)site.getConfig().get("factory");
        if (StringUtils.isNotBlank((String)factoryClassName)) {
            return (Factory)ClassUtils.newInstance(factoryClassName, site.getClassLoader(), site, site.getConfig());
        }
        FactoryImpl factory = new FactoryImpl();
        factory.setSite(site);
        return factory;
    }
}

