/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.Renderer;
import org.opoo.press.Site;
import org.opoo.press.SourceEntry;
import org.opoo.press.util.ClassUtils;
import org.opoo.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeMarkerRenderer
implements Renderer {
    private static final Logger log = LoggerFactory.getLogger(FreeMarkerRenderer.class);
    public static final String PROPERTY_PREFIX = "freemarker.";
    private Configuration configuration;
    private Site site;
    private File templateDir;
    private File workingTemplateDir;
    private Map<String, TemplateModel> templateModels;
    private long start = System.currentTimeMillis();

    public FreeMarkerRenderer(Site site) {
        this.site = site;
        this.templateDir = site.getTemplates();
        log.debug("Template directory: " + this.templateDir.getAbsolutePath());
        this.workingTemplateDir = new File(site.getWorking(), "templates");
        PathUtils.checkDir(this.workingTemplateDir, PathUtils.Strategy.CREATE_IF_NOT_EXISTS);
        log.debug("Working template directory: {}", (Object)this.workingTemplateDir.getAbsolutePath());
        this.configuration = new Configuration();
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.configuration.setTemplateLoader(this.buildTemplateLoader(site));
        Locale locale = site.getLocale();
        if (locale != null) {
            this.configuration.setLocale(site.getLocale());
        }
        this.initializeAutoImportTemplates(site, this.configuration);
        this.initializeAutoIncludeTemplates(site, this.configuration);
        this.initializeTemplateModels();
    }

    private void initializeTemplateModels() {
        this.templateModels = this.site.getFactory().getPluginManager().getObjectMap(TemplateModel.class);
        Map map = (Map)this.site.get(TemplateModel.class.getName());
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String name = (String)entry.getKey();
                String className = (String)entry.getValue();
                TemplateModel t = (TemplateModel)ClassUtils.newInstance(className, this.site.getClassLoader(), this.site, this.site.getConfig());
                log.debug("Create instance: {}", (Object)className);
                this.templateModels.put(name, t);
            }
        }
    }

    private void initializeAutoImportTemplates(Site site, Configuration configuration) {
        Map autoImportTemplates = (Map)site.get("freemarker.auto_import_templates");
        if (autoImportTemplates != null && !autoImportTemplates.isEmpty()) {
            for (Map.Entry en : autoImportTemplates.entrySet()) {
                configuration.addAutoImport((String)en.getKey(), (String)en.getValue());
                log.debug("Add auto import: " + (String)en.getKey() + " -> " + (String)en.getValue());
            }
        }
    }

    private void initializeAutoIncludeTemplates(Site site, Configuration configuration) {
        List autoIncludeTemplates = (List)site.get("freemarker.auto_include_templates");
        if (autoIncludeTemplates != null && !autoIncludeTemplates.isEmpty()) {
            for (String template : autoIncludeTemplates) {
                configuration.addAutoInclude(template);
                log.debug("Add auto include: " + template);
            }
        }
    }

    private TemplateLoader buildTemplateLoader(Site site) {
        try {
            ArrayList<Object> loaders = new ArrayList<Object>();
            loaders.add(new FileTemplateLoader(this.workingTemplateDir));
            loaders.add(new FileTemplateLoader(this.templateDir));
            loaders.add(new ClassTemplateLoader(FreeMarkerRenderer.class, "/org/opoo/press/templates"));
            List instances = site.getFactory().getPluginManager().getObjectList(TemplateLoader.class);
            if (instances != null && !instances.isEmpty()) {
                loaders.addAll(instances);
            }
            TemplateLoader[] loadersArray = loaders.toArray(new TemplateLoader[loaders.size()]);
            return new MultiTemplateLoader(loadersArray);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Site getSite() {
        return this.site;
    }

    public String render(String templateName, Map<String, Object> rootMap) {
        StringWriter out = new StringWriter();
        this.render(templateName, rootMap, out);
        IOUtils.closeQuietly((Writer)out);
        return out.toString();
    }

    public void render(String templateName, Map<String, Object> rootMap, Writer out) {
        log.debug("Rendering template {}", (Object)templateName);
        try {
            Template template = this.configuration.getTemplate(templateName, "UTF-8");
            this.process(template, rootMap, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    private void process(Template template, Map<String, Object> rootMap, Writer out) throws IOException, TemplateException {
        if (this.templateModels != null && !this.templateModels.isEmpty()) {
            rootMap.putAll(this.templateModels);
        }
        template.process(rootMap, out);
        out.flush();
    }

    public String prepareWorkingTemplate(String layout, boolean isValidLayout, String content, boolean isContentRenderRequired, SourceEntry entry) {
        log.debug("Prepare template for {}", (Object)entry.getFile());
        String name = isContentRenderRequired ? this.buildTemplateName(layout, entry) : this.getLayoutWorkingTemplate(layout);
        File targetTemplateFile = new File(this.workingTemplateDir, name);
        if (targetTemplateFile.exists() && targetTemplateFile.lastModified() >= entry.getLastModified()) {
            log.debug("Working template exists and newer than source file: {}", (Object)targetTemplateFile);
        } else {
            StringBuffer templateContent = this.buildTemplateContent(layout, isValidLayout, content, isContentRenderRequired);
            try {
                FileUtils.write((File)targetTemplateFile, (CharSequence)templateContent, (String)"UTF-8");
                log.debug("Create working template: {}", (Object)targetTemplateFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Write working template error: " + targetTemplateFile, e);
            }
        }
        return name;
    }

    private String buildTemplateName(String layout, SourceEntry entry) {
        String name = entry.getPath() + "/" + entry.getName() + "." + layout + ".ftl";
        return name;
    }

    private StringBuffer buildTemplateContent(String layout, boolean isValidLayout, String content, boolean isContentRenderRequired) {
        StringBuffer template = new StringBuffer();
        if (isValidLayout) {
            template.append("<#include \"/_" + layout + ".ftl\">");
            template.append("<@" + layout + "Layout>");
        }
        if (isContentRenderRequired) {
            template.append(content);
        } else {
            template.append("${content}");
        }
        if (isValidLayout) {
            template.append("</@" + layout + "Layout>");
        }
        return template;
    }

    public String renderContent(String templateContent, Map<String, Object> rootMap) {
        StringWriter out = new StringWriter();
        this.renderContent(templateContent, rootMap, out);
        IOUtils.closeQuietly((Writer)out);
        return out.toString();
    }

    public void renderContent(String templateContent, Map<String, Object> rootMap, Writer out) {
        log.debug("Rendering content...");
        try {
            Template template = new Template("CT" + this.start++, (Reader)new StringReader(templateContent), this.configuration, "UTF-8");
            this.process(template, rootMap, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRenderRequired(String content) {
        if (StringUtils.contains((String)content, (String)"<#")) {
            return true;
        }
        return StringUtils.contains((String)content, (String)"${");
    }

    public boolean isValidLayout(String layout) {
        if (layout == null) {
            return false;
        }
        if ("nil".equalsIgnoreCase(layout)) {
            return false;
        }
        if ("null".equalsIgnoreCase(layout)) {
            return false;
        }
        return !"none".equalsIgnoreCase(layout);
    }

    public void prepareLayoutWorkingTemplates() {
        File[] layoutFiles;
        log.debug("Prepare layout working templates...");
        File templates = this.site.getTemplates();
        for (File layoutFile : layoutFiles = templates.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith("_") && name.endsWith(".ftl");
            }
        })) {
            String layout = FilenameUtils.getBaseName((String)layoutFile.getName()).substring(1);
            String name = this.getLayoutWorkingTemplate(layout);
            File targetTemplateFile = new File(this.workingTemplateDir, name);
            if (targetTemplateFile.exists() && targetTemplateFile.lastModified() >= layoutFile.lastModified()) {
                log.debug("Layout template exists and newer than source file: {}", (Object)targetTemplateFile);
                continue;
            }
            StringBuffer templateContent = this.buildTemplateContent(layout, true, null, false);
            try {
                FileUtils.write((File)targetTemplateFile, (CharSequence)templateContent, (String)"UTF-8");
                log.debug("Create layout template: {}", (Object)targetTemplateFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Write layout template error: " + targetTemplateFile, e);
            }
        }
    }

    public String getLayoutWorkingTemplate(String layout) {
        return "_" + layout + ".content.ftl";
    }
}

