/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.Category;
import org.opoo.press.Config;
import org.opoo.press.Converter;
import org.opoo.press.Factory;
import org.opoo.press.Generator;
import org.opoo.press.NoFrontMatterException;
import org.opoo.press.Observer;
import org.opoo.press.Page;
import org.opoo.press.Post;
import org.opoo.press.Renderer;
import org.opoo.press.Site;
import org.opoo.press.SiteBuilder;
import org.opoo.press.Source;
import org.opoo.press.SourceEntry;
import org.opoo.press.SourceEntryLoader;
import org.opoo.press.SourceParser;
import org.opoo.press.StaticFile;
import org.opoo.press.Tag;
import org.opoo.press.Theme;
import org.opoo.press.ThemeCompiler;
import org.opoo.press.Writable;
import org.opoo.press.impl.CategoryImpl;
import org.opoo.press.impl.ConfigImpl;
import org.opoo.press.impl.FactoryImpl;
import org.opoo.press.impl.SiteObserver;
import org.opoo.press.impl.StaticFileImpl;
import org.opoo.press.impl.TagImpl;
import org.opoo.press.impl.ThemeImpl;
import org.opoo.press.processor.ProcessorsProcessor;
import org.opoo.press.task.RunnableTask;
import org.opoo.press.task.TaskExecutor;
import org.opoo.press.util.StaleUtils;
import org.opoo.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteImpl
implements Site,
SiteBuilder {
    private static final Logger log = LoggerFactory.getLogger(SiteImpl.class);
    private ConfigImpl config;
    private Map<String, Object> data;
    private File dest;
    private File templates;
    private File working;
    private File basedir;
    private ValidDirList sources;
    private ValidDirList assets;
    private String root;
    private List<Page> pages;
    private List<Post> posts;
    private List<StaticFile> staticFiles;
    private Map<String, Category> categories;
    private List<Tag> tags;
    private Date time;
    private boolean showDrafts = false;
    private Renderer renderer;
    private Locale locale;
    private String permalink;
    private TaskExecutor taskExecutor;
    private Theme theme;
    private ProcessorsProcessor processors;
    private ClassLoader classLoader;
    private Factory factory;

    public SiteImpl(ConfigImpl siteConfig) {
        this.config = siteConfig;
        this.data = new HashMap<String, Object>();
        this.basedir = this.config.getBasedir();
        this.root = this.config.get("root", "");
        this.permalink = (String)this.config.get("permalink");
        this.showDrafts = this.config.get("show_drafts", false);
        boolean debug = this.config.get("debug", false);
        if (this.showDrafts) {
            log.info("+ Show drafts option set 'ON'");
        }
        if (debug) {
            for (Map.Entry en : this.config.entrySet()) {
                String name = (String)en.getKey();
                name = StringUtils.leftPad((String)name, (int)25);
                log.info(name + ": " + en.getValue());
            }
        }
        this.theme = this.createTheme();
        this.templates = this.theme.getTemplates();
        log.debug("Template directory: {}", (Object)this.templates);
        this.sources = new ValidDirList();
        this.sources.addDir(this.theme.getSource());
        List sourcesConfig = (List)this.config.get("source_dirs");
        this.sources.addDirs(this.basedir, sourcesConfig);
        log.debug("Source directories: {}", (Object)this.sources);
        this.assets = new ValidDirList();
        this.assets.addDir(this.theme.getAssets());
        List assetsConfig = (List)this.config.get("asset_dirs");
        this.assets.addDirs(this.basedir, assetsConfig);
        log.debug("Assets directories: {}", (Object)this.assets);
        String destDir = (String)this.config.get("dest_dir");
        this.dest = PathUtils.appendBaseIfNotAbsolute(this.basedir, destDir);
        log.debug("Destination directory: {}", (Object)this.dest);
        String workingDir = (String)this.config.get("work_dir");
        this.working = PathUtils.appendBaseIfNotAbsolute(this.basedir, workingDir);
        log.debug("Working directory: {}", (Object)this.working);
        this.reset();
        this.setup();
    }

    private Theme createTheme() {
        String name = this.config.get("theme", "default");
        File themes = new File(this.config.getBasedir(), "themes");
        File themeDir = PathUtils.appendBaseIfNotAbsolute(themes, name);
        if (!themeDir.exists() || !themeDir.isDirectory()) {
            throw new IllegalArgumentException("Theme directory not exists or not valid, please install theme first: " + themeDir);
        }
        this.compileTheme(themeDir);
        return new ThemeImpl(themeDir, this);
    }

    private void compileTheme(File themeDir) {
        ThemeCompiler themeCompiler = (ThemeCompiler)this.config.get("theme.compiler");
        if (themeCompiler != null) {
            log.debug("Compile theme by '{}'", (Object)themeCompiler.getClass().getName());
            themeCompiler.compile(themeDir);
        } else {
            log.debug("no theme compiler found.");
        }
    }

    public void build() {
        this.build(false);
    }

    public void build(boolean force) {
        Iterator<File> i$;
        if (force) {
            log.info("force build.");
            this.buildInternal();
            return;
        }
        if (StaleUtils.isStale(this, false)) {
            this.buildInternal();
            return;
        }
        List<File> staleAssets = StaleUtils.getStaleAssets(this);
        if (staleAssets != null && (i$ = staleAssets.iterator()).hasNext()) {
            File staleAsset = i$.next();
            log.info("Copying stale asset: {}...", (Object)staleAsset);
            try {
                FileUtils.copyDirectory((File)staleAsset, (File)this.dest, (FileFilter)this.buildFilter());
                StaleUtils.saveLastBuildInfo(this);
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Copy stale asset exception: " + staleAsset, e);
            }
        }
        log.info("Nothing to build - all site output files are up to date.");
    }

    public void clean() throws Exception {
        log.info("Cleaning destination directory " + this.dest);
        FileUtils.deleteDirectory((File)this.dest);
        log.info("Cleaning working directory " + this.working);
        FileUtils.deleteDirectory((File)this.working);
    }

    private void buildInternal() {
        this.reset();
        this.read();
        this.generate();
        this.render();
        this.cleanup();
        this.write();
        StaleUtils.saveLastBuildInfo(this);
    }

    void reset() {
        this.time = this.config.get("time", new Date());
        this.pages = new ArrayList<Page>();
        this.posts = new ArrayList<Post>();
        this.staticFiles = Collections.synchronizedList(new ArrayList());
    }

    void resetCategories() {
        this.categories = new LinkedHashMap<String, Category>();
        TreeMap names = (TreeMap)this.config.get("category_names");
        if (names == null || names.isEmpty()) {
            return;
        }
        names = new TreeMap(names);
        for (Map.Entry en : names.entrySet()) {
            String path = (String)en.getKey();
            String name = (String)en.getValue();
            String nicename = path;
            String parentPath = null;
            int index = path.lastIndexOf(46);
            if (index != -1) {
                nicename = path.substring(index + 1);
                parentPath = path.substring(0, index);
            }
            Category parent = null;
            if (parentPath != null && (parent = this.categories.get(parentPath)) == null) {
                throw new IllegalArgumentException("Parent category not found: " + parentPath);
            }
            CategoryImpl category = new CategoryImpl(nicename, name, parent, this);
            this.categories.put(path, category);
        }
    }

    void resetTags() {
        this.tags = new ArrayList<Tag>();
        Map names = (Map)this.config.get("tag_names");
        if (names == null || names.isEmpty()) {
            return;
        }
        for (Map.Entry en : names.entrySet()) {
            this.tags.add(new TagImpl((String)en.getKey(), (String)en.getValue(), this));
        }
    }

    void setup() {
        for (File source : this.sources) {
            if (!this.dest.equals(source = PathUtils.canonical(source)) && !source.getAbsolutePath().startsWith(this.dest.getAbsolutePath())) continue;
            throw new IllegalArgumentException("Destination directory cannot be or contain the Source directory.");
        }
        String localeString = (String)this.config.get("locale");
        if (localeString != null) {
            this.locale = LocaleUtils.toLocale((String)localeString);
            log.debug("Set locale: " + this.locale);
        }
        this.classLoader = this.createClassLoader(this.config, this.theme);
        this.taskExecutor = new TaskExecutor(this.config);
        this.factory = FactoryImpl.createInstance(this);
        this.processors = new ProcessorsProcessor(this.factory.getPluginManager().getProcessors());
        this.renderer = this.factory.createRenderer((Site)this);
    }

    private ClassLoader createClassLoader(Config config, Theme theme) {
        File themeTargetPlugins;
        log.debug("Create site ClassLoader.");
        ClassLoader parent = SiteImpl.class.getClassLoader();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        String sitePluginDir = (String)config.get("plugin_dir");
        String themePluginDir = (String)theme.get("plugin_dir");
        ArrayList<File> classPathEntries = new ArrayList<File>(2);
        if (StringUtils.isNotBlank((String)sitePluginDir)) {
            File sitePlugins = PathUtils.canonical(new File(config.getBasedir(), sitePluginDir));
            this.addClassPathEntries(classPathEntries, sitePlugins);
        }
        if (StringUtils.isNotBlank((String)themePluginDir)) {
            File themePlugins = PathUtils.canonical(new File(theme.getPath(), themePluginDir));
            this.addClassPathEntries(classPathEntries, themePlugins);
        }
        File themeClasses = new File(theme.getPath(), "target/classes");
        File themeSrc = new File(theme.getPath(), "src");
        if (themeSrc.exists() && themeClasses.exists() && themeClasses.isDirectory()) {
            classPathEntries.add(themeClasses);
        }
        if ((themeTargetPlugins = new File(theme.getPath(), "target/plugins")).exists() && themeTargetPlugins.list().length > 0) {
            this.addClassPathEntries(classPathEntries, themeTargetPlugins);
        }
        if (classPathEntries.isEmpty()) {
            log.info("No custom classpath entries.");
            return parent;
        }
        URL[] urls = new URL[classPathEntries.size()];
        try {
            for (int i = 0; i < classPathEntries.size(); ++i) {
                urls[i] = ((File)classPathEntries.get(i)).toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return new URLClassLoader(urls, parent);
    }

    private void addClassPathEntries(List<File> classPathEntries, File dir) {
        File[] files;
        if (dir.exists() && (files = dir.listFiles(new ValidPluginClassPathEntryFileFilter())) != null && files.length > 0) {
            classPathEntries.addAll(Arrays.asList(files));
        }
    }

    void read() {
        this.resetCategories();
        this.resetTags();
        Runnable t1 = new Runnable(){

            @Override
            public void run() {
                SiteImpl.this.readSources();
            }
        };
        Runnable t2 = new Runnable(){

            @Override
            public void run() {
                SiteImpl.this.readStaticFiles();
            }
        };
        this.taskExecutor.run(t1, t2);
        this.postRead();
    }

    private void readSources() {
        log.info("Reading sources ...");
        SourceEntryLoader sourceEntryLoader = this.factory.getSourceEntryLoader();
        SourceParser sourceParser = this.factory.getSourceParser();
        FileFilter fileFilter = this.buildFilter();
        ArrayList list = new ArrayList();
        for (File src : this.sources) {
            List tempList = sourceEntryLoader.loadSourceEntries(src, fileFilter);
            if (tempList == null || tempList.isEmpty()) continue;
            list.addAll(tempList);
        }
        for (SourceEntry en : list) {
            this.read(en, sourceParser);
        }
        Collections.sort(this.posts);
        Collections.reverse(this.posts);
        this.setPostNextOrPrevious(this.posts);
    }

    private void setPostNextOrPrevious(List<Post> posts) {
        Iterator<Post> it = posts.iterator();
        Post prev = null;
        Post curr = null;
        while (it.hasNext()) {
            curr = it.next();
            if (prev != null) {
                prev.setPrevious(curr);
                curr.setNext(prev);
            }
            prev = curr;
        }
    }

    private void readStaticFiles() {
        log.info("Reading assets ...");
        SourceEntryLoader sourceEntryLoader = this.factory.getSourceEntryLoader();
        FileFilter fileFilter = this.buildFilter();
        for (File assetDir : this.assets) {
            List tempList = sourceEntryLoader.loadSourceEntries(assetDir, fileFilter);
            for (SourceEntry se : tempList) {
                log.debug("read static file {}", (Object)se.getFile());
                this.staticFiles.add(new StaticFileImpl(this, se));
            }
        }
    }

    private void postRead() {
        this.processors.postRead(this);
    }

    private void read(SourceEntry en, SourceParser parser) {
        try {
            Source src = parser.parse(en);
            log.debug("read source {}", (Object)src.getSourceEntry().getFile());
            Map map = src.getMeta();
            String layout = (String)map.get("layout");
            if ("post".equals(layout)) {
                this.readPost(src);
            } else {
                this.pages.add(this.factory.createPage((Site)this, src));
            }
        }
        catch (NoFrontMatterException e) {
            this.staticFiles.add(new StaticFileImpl(this, en));
        }
    }

    private void readPost(Source src) {
        if (this.isDraft(src.getMeta())) {
            if (this.showDrafts) {
                this.posts.add(this.factory.createDraft((Site)this, src));
            }
        } else {
            this.posts.add(this.factory.createPost((Site)this, src));
        }
    }

    private boolean isDraft(Map<String, Object> meta) {
        if (!meta.containsKey("published")) {
            return false;
        }
        Boolean b = (Boolean)meta.get("published");
        return b == false;
    }

    FileFilter buildFilter() {
        final List includes = (List)this.config.get("includes");
        final List excludes = (List)this.config.get("excludes");
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                if (includes != null && includes.contains(name)) {
                    return true;
                }
                if (excludes != null && excludes.contains(name)) {
                    return false;
                }
                char firstChar = name.charAt(0);
                if (firstChar == '.' || firstChar == '_' || firstChar == '#') {
                    return false;
                }
                char lastChar = name.charAt(name.length() - 1);
                if (lastChar == '~') {
                    return false;
                }
                return !file.isHidden();
            }
        };
    }

    void generate() {
        for (Generator g : this.factory.getPluginManager().getGenerators()) {
            g.generate((Site)this);
        }
        this.postGenerate();
    }

    private void postGenerate() {
        this.processors.postGenerate(this);
    }

    void render() {
        final Map<String, Object> rootMap = this.buildRootMap();
        this.renderer.prepareLayoutWorkingTemplates();
        log.info("Rendering {} posts...", (Object)this.posts.size());
        this.taskExecutor.run(this.posts, new RunnableTask<Post>(){

            @Override
            public void run(Post post) {
                post.convert();
                SiteImpl.this.postConvertPost(post);
                post.render(rootMap);
                SiteImpl.this.postRenderPost(post);
            }
        });
        this.postRenderPosts();
        log.info("Rendering {} pages...", (Object)this.pages.size());
        this.taskExecutor.run(this.pages, new RunnableTask<Page>(){

            @Override
            public void run(Page page) {
                page.convert();
                SiteImpl.this.postConvertPage(page);
                page.render(rootMap);
                SiteImpl.this.postRenderPage(page);
            }
        });
        this.postRenderPages();
    }

    private void postConvertPost(Post post) {
        this.processors.postConvertPost(this, post);
    }

    private void postConvertPage(Page page) {
        this.processors.postConvertPage(this, page);
    }

    private void postRenderPost(Post post) {
        this.processors.postRenderPost(this, post);
    }

    private void postRenderPosts() {
        this.processors.postRenderAllPosts(this);
    }

    private void postRenderPage(Page page) {
        this.processors.postRenderPage(this, page);
    }

    private void postRenderPages() {
        this.processors.postRenderAllPages(this);
    }

    Map<String, Object> buildRootMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("site", this);
        map.put("root_url", this.getRoot());
        map.put("basedir", this.getRoot());
        map.put("opoopress", this.config.get("opoopress"));
        map.put("theme", this.theme);
        return map;
    }

    void cleanup() {
        log.info("cleanup...");
        List<File> destFiles = this.getAllDestFiles(this.dest);
        ArrayList<File> files = new ArrayList<File>();
        for (StaticFile staticFile : this.staticFiles) {
            files.add(staticFile.getOutputFile(this.dest));
        }
        log.debug("Files in target: {}", (Object)destFiles.size());
        log.debug("Assets file in src: {}", (Object)files.size());
        for (File file : files) {
            destFiles.remove(file);
        }
        log.debug("Files in target will be deleted: {}", (Object)destFiles.size());
        if (!destFiles.isEmpty()) {
            this.taskExecutor.run(destFiles, new RunnableTask<File>(){

                @Override
                public void run(File file) {
                    FileUtils.deleteQuietly((File)file);
                    log.debug("File deleted: {}", (Object)file);
                }
            });
        }
        this.postCleanup();
    }

    private List<File> getAllDestFiles(File dest) {
        ArrayList<File> files = new ArrayList<File>();
        if (dest != null && dest.exists()) {
            this.listDestFiles(files, dest);
        }
        return files;
    }

    private void listDestFiles(List<File> files, File dir) {
        File[] list;
        for (File f : list = dir.listFiles()) {
            if (f.isFile()) {
                files.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.listDestFiles(files, f);
        }
    }

    private void postCleanup() {
        this.processors.postCleanup(this);
    }

    void write() {
        log.info("Writing {} posts, {} pages, and {} static files ...", new Object[]{this.posts.size(), this.pages.size(), this.staticFiles.size()});
        if (!this.dest.exists()) {
            this.dest.mkdirs();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.posts);
        list.addAll(this.pages);
        if (!this.staticFiles.isEmpty()) {
            list.addAll(this.staticFiles);
        }
        this.taskExecutor.run(list, new RunnableTask<Writable>(){

            @Override
            public void run(Writable o) {
                o.write(SiteImpl.this.dest);
            }
        });
        this.postWrite();
    }

    private void postWrite() {
        this.processors.postWrite(this);
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public List<Post> getPosts() {
        return this.posts;
    }

    public Config getConfig() {
        return this.config;
    }

    public List<File> getSources() {
        return this.sources;
    }

    public File getDestination() {
        return this.dest;
    }

    public List<StaticFile> getStaticFiles() {
        return this.staticFiles;
    }

    public Date getTime() {
        return this.time;
    }

    public Object get(String name) {
        if (this.data.containsKey(name)) {
            return this.data.get(name);
        }
        if (this.config.containsKey(name)) {
            return this.config.get(name);
        }
        if (this.theme != null) {
            return this.theme.get(name);
        }
        return null;
    }

    public void set(String name, Object value) {
        this.data.put(name, value);
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public File getTemplates() {
        return this.templates;
    }

    public List<File> getAssets() {
        return this.assets;
    }

    public File getWorking() {
        return this.working;
    }

    public Converter getConverter(Source source) {
        return this.factory.getPluginManager().getConverter(source);
    }

    public String getRoot() {
        return this.root;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public List<Category> getCategories() {
        return new CategoriesList(this.categories);
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public String buildCanonical(String url) {
        return url;
    }

    public String toSlug(String tagName) {
        return this.factory.getSlugHelper().toSlug(tagName);
    }

    public String toNicename(String categoryName) {
        return this.factory.getSlugHelper().toSlug(categoryName);
    }

    public Category getCategory(String categoryNameOrNicename) {
        if (this.categories == null || this.categories.isEmpty()) {
            return null;
        }
        if (this.categories.containsKey(categoryNameOrNicename)) {
            return this.categories.get(categoryNameOrNicename);
        }
        for (Category category : new ArrayList<Category>(this.categories.values())) {
            if (!category.isNameOrNicename(categoryNameOrNicename)) continue;
            return category;
        }
        return null;
    }

    public Tag getTag(String tagNameOrSlug) {
        if (this.tags == null || this.tags.isEmpty()) {
            return null;
        }
        for (Tag tag : new ArrayList<Tag>(this.tags)) {
            if (!tag.isNameOrSlug(tagNameOrSlug)) continue;
            return tag;
        }
        return null;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public Observer getObserver() {
        return new SiteObserver(this);
    }

    public boolean showDrafts() {
        return this.showDrafts;
    }

    public Theme getTheme() {
        return this.theme;
    }

    ProcessorsProcessor getProcessors() {
        return this.processors;
    }

    static class ValidPluginClassPathEntryFileFilter
    implements FileFilter {
        ValidPluginClassPathEntryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            char firstChar = name.charAt(0);
            if (firstChar == '.' || firstChar == '_' || firstChar == '#') {
                return false;
            }
            char lastChar = name.charAt(name.length() - 1);
            if (lastChar == '~') {
                return false;
            }
            if (file.isHidden()) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return file.isFile() && ((name = name.toLowerCase()).endsWith(".jar") || name.endsWith(".zip"));
        }
    }

    static class ValidDirList
    extends ArrayList<File> {
        private static final long serialVersionUID = 6306507738477638252L;

        ValidDirList() {
        }

        public ValidDirList addDir(File dir) {
            if (PathUtils.isValidDirectory(dir)) {
                this.add(dir);
            }
            return this;
        }

        public ValidDirList addDir(File base, String path) {
            return this.addDir(new File(base, path));
        }

        public ValidDirList addDirs(File base, List<String> paths) {
            for (String path : paths) {
                this.addDir(base, path);
            }
            return this;
        }
    }

    private static class CategoriesList
    extends AbstractList<Category> {
        private final List<Category> list = new ArrayList<Category>();
        private final Map<String, Category> categories;

        private CategoriesList(Map<String, Category> categories) {
            this.categories = categories;
            for (Category category : categories.values()) {
                if (category.getPosts().isEmpty()) continue;
                this.list.add(category);
            }
        }

        @Override
        public boolean add(Category category) {
            this.categories.put(category.getPath(), category);
            return this.list.add(category);
        }

        @Override
        public Category get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }
}

