/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.Config;
import org.opoo.press.Site;
import org.opoo.press.SiteManager;
import org.opoo.press.impl.ConfigImpl;
import org.opoo.press.util.LinkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteManagerImpl
implements SiteManager {
    private static final Logger log = LoggerFactory.getLogger(SiteManagerImpl.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public void initialize(File baseDirectory, Locale locale) throws Exception {
        this.updateConfigurationFile(baseDirectory, locale);
        this.checkDirectories(baseDirectory);
    }

    private void updateConfigurationFile(File baseDirectory, Locale locale) {
        boolean isZH;
        File configFile = new File(baseDirectory, "config.yml");
        File configFileZH = new File(baseDirectory, "config_zh_CN.yml");
        if (!configFileZH.exists()) {
            log.debug("config-zh_CN.yml not exists, skip update.");
            return;
        }
        if (!configFile.exists()) {
            configFileZH.renameTo(configFile);
            return;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (isZH = "zh".equals(locale.getLanguage())) {
            FileUtils.deleteQuietly((File)configFile);
            configFileZH.renameTo(configFile);
        } else {
            FileUtils.deleteQuietly((File)configFileZH);
        }
    }

    private void checkDirectories(File baseDirectory) throws Exception {
        HashMap<String, Object> override = new HashMap<String, Object>();
        ConfigImpl config = new ConfigImpl(baseDirectory, override);
        File[] configFiles = config.getConfigFiles();
        if (configFiles.length == 0) {
            log.warn("No site configuration file.");
            return;
        }
        List sourcesConfig = (List)config.get("source_dirs");
        this.checkDirectoryList(baseDirectory, sourcesConfig);
        List assetsConfig = (List)config.get("asset_dirs");
        this.checkDirectoryList(baseDirectory, assetsConfig);
        String sitePluginsDir = (String)config.get("plugin_dir");
        this.checkDirectory(baseDirectory, sitePluginsDir);
        this.checkDirectory(baseDirectory, "themes");
    }

    private void checkDirectoryList(File basedir, List<String> dirs) throws Exception {
        if (dirs != null && !dirs.isEmpty()) {
            for (String dir : dirs) {
                this.checkDirectory(basedir, dir);
            }
        }
    }

    private void checkDirectory(File basedir, String dir) throws Exception {
        File file = new File(basedir, dir);
        if (!file.exists()) {
            file.mkdirs();
            log.info("mkdir: {}", (Object)file);
        } else if (!(file.isDirectory() && file.canRead() && file.canWrite())) {
            throw new Exception(file + " must be a valid directory.");
        }
    }

    public File createNewFile(Site site, String layout, String title, String name, String format, String newFilePattern, String template, Map<String, Object> meta) throws Exception {
        name = this.processName(site, title, name);
        if (format == null) {
            format = "markdown";
        }
        Config config = site.getConfig();
        if (StringUtils.isBlank((String)newFilePattern) && StringUtils.isBlank((String)(newFilePattern = (String)config.get("new_" + layout)))) {
            if ("post".equals(layout)) {
                newFilePattern = "posts/${year}-${month}-${day}-${name}.${format}";
            } else if ("page".equals(layout)) {
                newFilePattern = "pages/${name}.${format}";
            }
        }
        if (StringUtils.isBlank((String)template) && StringUtils.isBlank((String)(template = (String)config.get("new_" + layout + "_template")))) {
            if ("post".equals(layout)) {
                template = "new_post.ftl";
            } else if ("page".equals(layout)) {
                template = "new_page.ftl";
            }
        }
        return this.renderFile(site, title, name, format, newFilePattern, template, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File renderFile(Site site, String title, String name, String format, String newFilePattern, String template, Map<String, Object> meta) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (meta != null) {
            map.putAll(meta);
        }
        if (title != null) {
            map.put("title", title);
        }
        if (name != null) {
            map.put("name", name);
        }
        map.put("format", format);
        Date date = new Date();
        map.put("date", DATE_FORMAT.format(date));
        LinkUtils.addDateParams(map, date);
        String filename = this.renderFilename(newFilePattern, map);
        File file = new File(site.getBasedir(), filename);
        map.put("site", site);
        map.put("file", file);
        map.put("opoopress", site.getConfig().get("opoopress"));
        FileOutputStream os = null;
        OutputStreamWriter out = null;
        try {
            file.getParentFile().mkdirs();
            os = new FileOutputStream(file);
            out = new OutputStreamWriter((OutputStream)os, "UTF-8");
            site.getRenderer().render(template, map, (Writer)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
        IOUtils.closeQuietly((OutputStream)os);
        log.info("Write to file: {}", (Object)file);
        return file;
    }

    private String processName(Site site, String title, String name) {
        if (name == null) {
            log.info("Using title as post name.");
            name = title;
        } else {
            name = name.trim();
        }
        name = site.toSlug(name);
        return name;
    }

    private String renderFilename(String filenamePattern, Map<String, Object> rootMap) throws Exception {
        Configuration configuration = new Configuration();
        Template template = new Template("filename", (Reader)new StringReader(filenamePattern), configuration, "UTF-8");
        StringWriter writer = new StringWriter();
        template.process(rootMap, (Writer)writer);
        writer.flush();
        return writer.toString();
    }
}

