/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.opoo.press.Config;
import org.opoo.press.Observer;
import org.opoo.press.SourceEntry;
import org.opoo.press.SourceEntryLoader;
import org.opoo.press.file.Result;
import org.opoo.press.file.Watchable;
import org.opoo.press.file.WatchableDirectory;
import org.opoo.press.file.WatchableFiles;
import org.opoo.press.impl.ConfigImpl;
import org.opoo.press.impl.SiteImpl;
import org.opoo.press.impl.StaticFileImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteObserver
implements Observer {
    private static final Logger log = LoggerFactory.getLogger(SiteObserver.class);
    private final SiteImpl site;
    private Observer themeObserver;
    private List<Watchable> configWatchers = new ArrayList<Watchable>();
    private List<Watchable> otherWatchers = new ArrayList<Watchable>();

    SiteObserver(SiteImpl site) {
        this.site = site;
        this.themeObserver = site.getTheme().getObserver();
        FileFilter siteConfigFilesFilter = this.createConfigFilesFilter();
        WatchableDirectory siteConfigWatcher = new WatchableDirectory(site.getBasedir(), siteConfigFilesFilter);
        this.configWatchers.add(siteConfigWatcher);
        WatchableFiles themeConfigWatcher = new WatchableFiles(site.getTheme().getConfigFile());
        this.configWatchers.add(themeConfigWatcher);
        List<File> sources = site.getSources();
        for (File source : sources) {
            this.otherWatchers.add(new WatchableDirectory(source));
        }
        this.otherWatchers.add(new WatchableDirectory(site.getTemplates()));
        List<File> assets = site.getAssets();
        for (File asset : assets) {
            this.otherWatchers.add(new StaticFilesWatcher(asset));
        }
    }

    private FileFilter createConfigFilesFilter() {
        Config config = this.site.getConfig();
        boolean useDefaultConfigFiles = config.useDefaultConfigFiles();
        if (useDefaultConfigFiles) {
            log.debug("Using default config files.");
            return ConfigImpl.DEFAULT_CONFIG_FILES_FILTER;
        }
        final File[] configFiles = config.getConfigFiles();
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                for (File configFile : configFiles) {
                    if (!configFile.equals(file)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public void initialize() throws Exception {
        if (this.themeObserver != null) {
            this.themeObserver.initialize();
        }
        for (Watchable watcher : this.configWatchers) {
            watcher.initialize();
        }
        for (Watchable watcher : this.otherWatchers) {
            watcher.initialize();
        }
    }

    public void check() throws Exception {
        if (this.themeObserver != null) {
            this.themeObserver.check();
        }
        for (Watchable watcher : this.configWatchers) {
            Result result = watcher.check();
            if (result.isEmpty()) continue;
            log.info("Configuration file changed: \n{}", (Object)result.toString());
            throw new ConfigChangedException(result);
        }
        Result result = Result.newResult();
        for (Watchable watcher : this.otherWatchers) {
            Result check = watcher.check();
            if (check.isEmpty()) continue;
            result.addResult(check);
        }
        if (!result.isEmpty()) {
            log.info("Source file(s) changed: \n{}", (Object)result.toString());
            long start = System.currentTimeMillis();
            this.site.build(true);
            log.info("Build time: {}ms", (Object)(System.currentTimeMillis() - start));
        } else {
            log.debug("Nothing to build - all site output files are up to date.");
        }
    }

    public void destroy() throws Exception {
        if (this.themeObserver != null) {
            this.themeObserver.destroy();
        }
        for (Watchable watcher : this.configWatchers) {
            watcher.destroy();
        }
        for (Watchable watcher : this.otherWatchers) {
            watcher.destroy();
        }
    }

    private class StaticFilesWatcher
    extends WatchableDirectory {
        private File dir;

        public StaticFilesWatcher(File directory) {
            super(directory);
        }

        public void onStart(FileAlterationObserver observer) {
            this.dir = observer.getDirectory();
        }

        @Override
        public void onFileCreate(File file) {
            this.onFileChange(file);
        }

        @Override
        public void onFileChange(File file) {
            SourceEntryLoader loader = SiteObserver.this.site.getFactory().getSourceEntryLoader();
            SourceEntry sourceEntry = loader.buildSourceEntry(this.dir, file);
            StaticFileImpl staticFile = new StaticFileImpl(SiteObserver.this.site, sourceEntry);
            staticFile.write(SiteObserver.this.site.getDestination());
            log.info("Copy static file: {} => {}", (Object)file, (Object)SiteObserver.this.site.getDestination());
        }

        @Override
        public void onFileDelete(File file) {
            log.info("Static file deleted: {}", (Object)file);
            String filePath = file.getAbsolutePath();
            String dirPath = this.dir.getAbsolutePath();
            String string = filePath.replace(dirPath, "");
            while (string.startsWith("/") || string.startsWith("\\")) {
                string = string.substring(1);
            }
            File destFile = new File(SiteObserver.this.site.getDestination(), string);
            if (destFile.exists()) {
                FileUtils.deleteQuietly((File)destFile);
                log.info("Delete static file: {}", (Object)destFile);
            }
        }
    }

    public static class ConfigChangedException
    extends Exception {
        private Result result;

        public ConfigChangedException(Result result) {
            this.result = result;
        }

        public Result getResult() {
            return this.result;
        }
    }
}

