/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.Observer;
import org.opoo.press.ObserversObserver;
import org.opoo.press.ResourceBuilder;
import org.opoo.press.Theme;
import org.opoo.press.impl.SiteImpl;
import org.opoo.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class ThemeImpl
implements Theme {
    public static final String THEME_CONFIGURATION_FILENAME = "theme.yml";
    public static final String RESOURCE_BUILDERS_CONFIGURATION_FILENAME = "resource-builders.yml";
    private static final Logger log = LoggerFactory.getLogger(ThemeImpl.class);
    private final File path;
    private final File configFile;
    private Map<String, Object> config;
    private File source;
    private File assets;
    private File templates;
    private final SiteImpl site;
    private List<ResourceBuilder> builders;

    ThemeImpl(File path, SiteImpl site) {
        this.site = site;
        this.path = PathUtils.canonical(path);
        this.configFile = new File(path, THEME_CONFIGURATION_FILENAME);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.configFile);
            this.config = (Map)new Yaml().loadAs((InputStream)stream, Map.class);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalArgumentException("Theme configuration file not found: " + this.configFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        String sourceConfig = (String)this.config.get("source_dir");
        if (StringUtils.isBlank((String)sourceConfig)) {
            sourceConfig = "sources";
        }
        this.source = new File(path, sourceConfig);
        String assetsConfig = (String)this.config.get("asset_dir");
        if (StringUtils.isBlank((String)assetsConfig)) {
            assetsConfig = "assets";
        }
        this.assets = new File(path, assetsConfig);
        String templatesConfig = (String)this.config.get("template_dir");
        if (StringUtils.isBlank((String)templatesConfig)) {
            templatesConfig = "templates";
        }
        this.templates = new File(path, templatesConfig);
    }

    public File getConfigFile() {
        return this.configFile;
    }

    private void initializeResourceBuilders() {
        block6: {
            List resourceBuildersConfig;
            if (this.builders != null) break block6;
            this.builders = new ArrayList<ResourceBuilder>();
            File themeBuildersConfigFile = new File(this.path, RESOURCE_BUILDERS_CONFIGURATION_FILENAME);
            if (!themeBuildersConfigFile.exists()) {
                return;
            }
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(themeBuildersConfigFile);
                resourceBuildersConfig = (List)new Yaml().loadAs((InputStream)stream, List.class);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new IllegalArgumentException("Resource builders configuration file not found: " + this.configFile);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
            for (Map config : resourceBuildersConfig) {
                ResourceBuilder resourceBuilder = this.createResourceBuilder(config);
                this.builders.add(resourceBuilder);
                log.debug("Initializing resource builder: {}", (Object)resourceBuilder);
                resourceBuilder.init(this.path, config);
            }
        }
    }

    protected ResourceBuilder createResourceBuilder(Map<String, Object> config) {
        String type = (String)config.get("type");
        if (StringUtils.isBlank((String)type)) {
            throw new IllegalArgumentException("The type of resource builder is required.");
        }
        return this.site.getFactory().createResourceBuilder(type);
    }

    public File getPath() {
        return this.path;
    }

    public File getSource() {
        return this.source;
    }

    public File getTemplates() {
        return this.templates;
    }

    public File getAssets() {
        return this.assets;
    }

    public void build() {
        if (this.site != null) {
            this.site.getProcessors().beforeBuildTheme(this);
        }
        this.initializeResourceBuilders();
        if (!this.builders.isEmpty()) {
            try {
                for (ResourceBuilder builder : this.builders) {
                    builder.build();
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Theme build exception", e);
            }
        }
        if (this.site != null) {
            this.site.getProcessors().afterBuildTheme(this);
        }
    }

    public Object get(String name) {
        return this.config.get(name);
    }

    public Observer getObserver() {
        this.initializeResourceBuilders();
        if (this.builders.isEmpty()) {
            return null;
        }
        ArrayList<Observer> list = new ArrayList<Observer>();
        for (ResourceBuilder builder : this.builders) {
            if (!(builder instanceof Observer)) continue;
            list.add((Observer)builder);
        }
        return new ObserversObserver(list);
    }

    public void clean() throws Exception {
        this.initializeResourceBuilders();
        if (!this.builders.isEmpty()) {
            for (ResourceBuilder builder : this.builders) {
                builder.clean();
            }
        }
    }
}

