/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.processor;

import java.util.List;
import org.opoo.press.Page;
import org.opoo.press.Post;
import org.opoo.press.Processor;
import org.opoo.press.Site;
import org.opoo.press.Theme;

public class ProcessorsProcessor
implements Processor {
    private final List<Processor> processors;

    public ProcessorsProcessor(List<Processor> processors) {
        this.processors = processors;
    }

    public int getOrder() {
        return 0;
    }

    public void postSetup(Site site) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.postSetup(site);
            }
        }
    }

    public void postRead(Site site) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.postRead(site);
            }
        }
    }

    public void postGenerate(Site site) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.postGenerate(site);
            }
        }
    }

    public void postConvertPost(Site site, Post post) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.postConvertPost(site, post);
            }
        }
    }

    public void postConvertPage(Site site, Page page) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.postConvertPage(site, page);
            }
        }
    }

    public void preRenderPost(Site site, Post post) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.preRenderPost(site, post);
            }
        }
    }

    public void postRenderPost(Site site, Post post) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.postRenderPost(site, post);
            }
        }
    }

    public void preRenderPage(Site site, Page page) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.preRenderPage(site, page);
            }
        }
    }

    public void postRenderPage(Site site, Page page) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.postRenderPage(site, page);
            }
        }
    }

    public void postRenderAllPosts(Site site) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.postRenderAllPosts(site);
            }
        }
    }

    public void postRenderAllPages(Site site) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.postRenderAllPages(site);
            }
        }
    }

    public void postWrite(Site site) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.postWrite(site);
            }
        }
    }

    public void postCleanup(Site site) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.postCleanup(site);
            }
        }
    }

    public void beforeBuildTheme(Theme theme) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.afterBuildTheme(theme);
            }
        }
    }

    public void afterBuildTheme(Theme theme) {
        if (this.processors != null) {
            for (Processor p : this.processors) {
                p.afterBuildTheme(theme);
            }
        }
    }
}

