/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.resource;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.monitor.FileEntry;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.BiVariableMap;
import org.opoo.press.Observer;
import org.opoo.press.ResourceBuilder;
import org.opoo.press.file.Result;
import org.opoo.press.file.Watchable;
import org.opoo.press.file.WatchableDirectory;
import org.opoo.press.resource.Compass;
import org.opoo.util.MapUtils;
import org.opoo.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompassBuilder
implements ResourceBuilder,
Observer {
    private static final Logger log = LoggerFactory.getLogger(CompassBuilder.class);
    public static final String DEFAULT_CONFIG_FILE_NAME = "config.rb";
    public static final String CACHE_FILE_SUFFIX = ".cache";
    private File themePath;
    private File configFile;
    private File sassPath;
    private File cssPath;
    private Watchable sassWatchable;
    private FileEntry configFileEntry;

    public void init(File resourceBaseDirectory, Map<String, Object> config) {
        this.themePath = resourceBaseDirectory;
        String fileName = MapUtils.get(config, "configFile", DEFAULT_CONFIG_FILE_NAME);
        this.configFile = new File(resourceBaseDirectory, fileName);
        if (!this.configFile.exists() || !this.configFile.canRead()) {
            throw new IllegalArgumentException("Compass configuration file not exists or invalid: " + this.configFile);
        }
    }

    protected boolean shouldBuild() {
        this.prepareSassAndCssPaths();
        long configFileLastModified = this.configFile.lastModified();
        List<File> partialSassFiles = PathUtils.listFiles(this.sassPath, new PartialSassFilenameFilter(), true);
        File lastModifiedPartialSassFile = this.getLastModifiedFile(partialSassFiles);
        long partialSassFileLastModified = lastModifiedPartialSassFile.lastModified();
        int sassPathLength = this.sassPath.getPath().length() + 1;
        List<File> mainSassFiles = PathUtils.listFiles(this.sassPath, new MainSassFilenameFilter(), true);
        for (File sassFile : mainSassFiles) {
            String relativeSassFilePath = sassFile.getPath().substring(sassPathLength);
            String cssFilePath = FilenameUtils.removeExtension((String)relativeSassFilePath) + ".css";
            File cssFile = new File(this.cssPath, cssFilePath);
            log.debug("Checking {} => {}", (Object)sassFile, (Object)cssFile);
            if (!cssFile.exists()) {
                log.debug("css file '{}' not eixsts, need compile.", (Object)cssFile);
                return true;
            }
            long cssFileLastModified = cssFile.lastModified();
            if (configFileLastModified > cssFileLastModified) {
                log.debug("css file '{}' is older than compass configuration file, need compile.", (Object)cssFile);
                return true;
            }
            if (sassFile.lastModified() > cssFileLastModified) {
                log.debug("css file '{}' is older than sass file '{}', need compile.", (Object)cssFile, (Object)sassFile);
                return true;
            }
            if (partialSassFileLastModified <= cssFileLastModified) continue;
            log.debug("css file '{}' is older than sass partial '{}', need compile.", (Object)cssFile, (Object)lastModifiedPartialSassFile);
            return true;
        }
        return false;
    }

    private File getLastModifiedFile(List<File> files) {
        File lastModifiedFile = null;
        for (File f : files) {
            if (lastModifiedFile == null) {
                lastModifiedFile = f;
                continue;
            }
            if (f.lastModified() <= lastModifiedFile.lastModified()) continue;
            lastModifiedFile = f;
        }
        return lastModifiedFile;
    }

    private void prepareSassAndCssPaths() {
        if (this.sassPath != null && this.cssPath != null) {
            return;
        }
        File cacheFile = this.getCacheFile();
        Properties cache = null;
        if (!cacheFile.exists() || this.configFile.lastModified() > cacheFile.lastModified()) {
            log.debug("Cache file not exists or older than configuration file, create cache now: {}", (Object)cacheFile);
            cache = this.createCache(this.configFile, cacheFile);
        } else {
            cache = this.loadCache(cacheFile);
        }
        String sassDir = cache.getProperty("sass_dir", "sass");
        String cssDir = cache.getProperty("css_dir", "assets/stylesheets");
        this.sassPath = new File(this.themePath, sassDir);
        this.cssPath = new File(this.themePath, cssDir);
    }

    private File getCacheFile() {
        String name = this.configFile.getName() + CACHE_FILE_SUFFIX;
        if (name.charAt(0) != '.') {
            name = "." + name;
        }
        return new File(this.themePath, name);
    }

    private Properties createCache(File configFile, File cacheFile) {
        ScriptingContainer container = new ScriptingContainer(LocalVariableBehavior.PERSISTENT);
        container.runScriptlet(PathType.ABSOLUTE, configFile.getAbsolutePath());
        BiVariableMap varMap = container.getVarMap();
        Set entrySet = varMap.entrySet();
        Properties props = new Properties();
        for (Map.Entry en : entrySet) {
            if (!(en.getValue() instanceof String)) continue;
            props.setProperty((String)en.getKey(), (String)en.getValue());
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(cacheFile);
            props.store(outputStream, "Compass configuration cache");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return props;
    }

    private Properties loadCache(File cacheFile) {
        Properties properties;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(cacheFile);
            Properties props = new Properties();
            props.load(inputStream);
            properties = props;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return properties;
    }

    public void initialize() throws Exception {
        log.debug("Initialize the observer.");
        this.configFileEntry = new FileEntry(this.configFile);
        this.configFileEntry.refresh(this.configFile);
        this.prepareSassAndCssPaths();
        this.sassWatchable = new WatchableDirectory(this.sassPath, (FileFilter)new SassFileFilter());
        this.sassWatchable.initialize();
    }

    public void check() throws Exception {
        if (this.configFileEntry.refresh(this.configFile)) {
            log.debug("Compass configuration file changed, need compile.");
            this.buildInternal();
            return;
        }
        Result result = this.sassWatchable.check();
        if (!result.isEmpty()) {
            log.debug("File(s) changed:\n{}", (Object)result.toString());
            this.buildInternal();
        } else {
            log.debug("Nothing to compile - all css files are up to date");
        }
    }

    public void destroy() throws Exception {
        this.sassWatchable.destroy();
    }

    public void build() throws Exception {
        if (this.shouldBuild()) {
            this.buildInternal();
        } else {
            log.debug("Nothing to compile - all css files are up to date");
        }
    }

    public void clean() throws Exception {
        File cacheFile = this.getCacheFile();
        if (cacheFile.exists()) {
            log.debug("Delete cache file '{}'", (Object)cacheFile);
            FileUtils.deleteQuietly((File)cacheFile);
        }
        if (this.sassPath != null && this.sassPath.exists() && this.cssPath != null & this.cssPath.exists()) {
            int sassPathLength = this.sassPath.getPath().length() + 1;
            List<File> mainSassFiles = PathUtils.listFiles(this.sassPath, new MainSassFilenameFilter(), true);
            for (File sassFile : mainSassFiles) {
                String relativeSassFilePath = sassFile.getPath().substring(sassPathLength);
                String cssFilePath = FilenameUtils.removeExtension((String)relativeSassFilePath) + ".css";
                File cssFile = new File(this.cssPath, cssFilePath);
                if (!cssFile.exists()) continue;
                log.debug("Cleaning {}", (Object)cssFile);
                FileUtils.deleteQuietly((File)cssFile);
            }
        }
    }

    private void buildInternal() {
        new Compass(this.themePath, this.configFile).compile();
    }

    public String toString() {
        if (this.configFile == null) {
            return super.toString();
        }
        return String.format("CompassThemeBuilder(config=%s)", this.configFile);
    }

    public static class SassFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            char firstChar = name.charAt(0);
            if (firstChar == '.' || firstChar == '#') {
                return false;
            }
            return name.endsWith(".scss") || name.endsWith(".sass");
        }
    }

    public static class PartialSassFilenameFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File file, String name) {
            return name.charAt(0) == '_' && (name.endsWith(".scss") || name.endsWith(".sass"));
        }
    }

    public static class MainSassFilenameFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            char firstChar = name.charAt(0);
            if (firstChar == '.' || firstChar == '_' || firstChar == '#') {
                return false;
            }
            return name.endsWith(".scss") || name.endsWith(".sass");
        }
    }
}

