/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.resource;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.jruby.embed.ScriptingContainer;
import org.opoo.press.resource.Compass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompassV2 {
    private static final Logger log = LoggerFactory.getLogger(Compass.class);
    private String path;
    private String config;
    private String compileScript;
    private String watchScript;

    static List<String> toCompassConfigFileLines(Map<String, Object> options) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Map.Entry<String, Object> en : options.entrySet()) {
            Object value = en.getValue();
            if (value instanceof String && !((String)value).startsWith(":")) {
                value = "\"" + value + "\"";
            }
            String string = String.format("%s = %s", en.getKey(), value);
            lines.add(string);
        }
        return lines;
    }

    static String toCompassConfigRubyScript(Map<String, Object> options) {
        StringBuffer sb = new StringBuffer("{");
        for (Map.Entry<String, Object> en : options.entrySet()) {
            Object value = en.getValue();
            if (value instanceof String && !((String)value).startsWith(":")) {
                value = "'" + value + "'";
            }
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(":").append(en.getKey()).append(" => ").append(value);
        }
        sb.append("}");
        return sb.toString();
    }

    CompassV2(File path, Map<String, Object> options) {
        this.path = FilenameUtils.separatorsToUnix((String)path.getAbsolutePath());
        this.config = CompassV2.toCompassConfigRubyScript(options);
    }

    public void compile() {
        if (this.compileScript == null) {
            this.compileScript = this.buildCompileScript();
        }
        this.runScriptlet(this.compileScript);
    }

    public void watch() {
        if (this.watchScript == null) {
            this.watchScript = this.buildWatchScript();
        }
        this.runScriptlet(this.watchScript);
    }

    private void runScriptlet(String script) {
        log.debug(script);
        new ScriptingContainer().runScriptlet(script);
    }

    private void buildBasicScript(PrintWriter script) {
        script.println("require 'compass'");
        script.println("frameworks = Dir.new(Compass::Frameworks::DEFAULT_FRAMEWORKS_PATH).path");
        script.println("Compass::Frameworks.register_directory(File.join(frameworks, 'compass'))");
        script.println("Compass::Frameworks.register_directory(File.join(frameworks, 'blueprint'))");
        script.println("Compass.add_configuration(" + this.config + ", 'custom')");
        script.println("Compass.configure_sass_plugin!");
    }

    private String buildCompileScript() {
        StringWriter raw = new StringWriter();
        PrintWriter script = new PrintWriter(raw);
        this.buildBasicScript(script);
        script.println("Dir.chdir('" + this.path + "') do ");
        script.println("  Compass.compiler.run");
        script.println("end");
        script.flush();
        return raw.toString();
    }

    private String buildWatchScript() {
        StringWriter raw = new StringWriter();
        PrintWriter script = new PrintWriter(raw);
        this.buildBasicScript(script);
        script.println("require 'compass/commands'");
        script.println("command = Compass::Commands::WatchProject.new('" + this.path + "', {})");
        script.println("command.perform");
        script.flush();
        return raw.toString();
    }
}

