/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.resource;

import com.yahoo.platform.yui.compressor.YUICompressor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.opoo.press.Observer;
import org.opoo.press.ResourceBuilder;
import org.opoo.util.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YUIBuilder
implements ResourceBuilder,
Observer {
    private static final Logger log = LoggerFactory.getLogger(YUIBuilder.class);
    public String charset = "UTF-8";
    public int lineBreak = -1;
    public boolean verbose = false;
    public boolean nomunge = false;
    public boolean preserveSemi = false;
    public boolean disableOptimizations = false;
    public boolean mergeOnly = false;
    private String type;
    private List<File> inputFiles;
    private File outputFile;

    public void init(File resourceBaseDirectory, Map<String, Object> config) {
        throw new UnsupportedOperationException("init() method must override in derived class.");
    }

    protected YUIBuilder init(String type, Map<String, Object> config) {
        return this.init(type, null, config);
    }

    protected YUIBuilder init(String type, File base, Map<String, Object> config) {
        this.type = type;
        this.inputFiles = YUIBuilder.parseInputFiles(base, config);
        this.outputFile = YUIBuilder.parseOutputFile(base, config);
        this.lineBreak = MapUtils.get(config, "line-break", this.lineBreak);
        this.charset = MapUtils.get(config, "charset", this.charset);
        this.verbose = MapUtils.get(config, "verbose", this.verbose);
        this.mergeOnly = MapUtils.get(config, "merge-only", this.mergeOnly);
        if (type.equalsIgnoreCase("js")) {
            this.nomunge = MapUtils.get(config, "nomunge", this.nomunge);
            this.preserveSemi = MapUtils.get(config, "preserve-semi", this.preserveSemi);
            this.disableOptimizations = MapUtils.get(config, "disable-optimizations", this.disableOptimizations);
        }
        return this;
    }

    private static List<File> parseInputFiles(File base, Map<String, Object> config) {
        Object input = config.get("input");
        List<String> inputPaths = input instanceof String ? Arrays.asList((String)input) : (List<String>)input;
        if (inputPaths == null || inputPaths.isEmpty()) {
            throw new IllegalArgumentException("input is required.");
        }
        ArrayList<File> inputFiles = new ArrayList<File>();
        for (String inputPath : inputPaths) {
            File inputFile = base == null ? new File(inputPath) : new File(base, inputPath);
            inputFiles.add(inputFile);
        }
        return inputFiles;
    }

    private static File parseOutputFile(File base, Map<String, Object> config) {
        String output = (String)config.get("output");
        return base == null ? new File(output) : new File(base, output);
    }

    protected void compress(File inputFile, File outputFile) throws Exception {
        this.compress(inputFile.toString(), outputFile.toString());
    }

    protected void compress(String input, String output) throws Exception {
        log.info("Compressing file '{}' to '{}'", (Object)input, (Object)output);
        Args args = this.createCompressArgs().add(input).add("-o").add(output);
        log.debug("args: {}", (Object)args);
        YUICompressor.main((String[])args.toArray());
    }

    private Args createCompressArgs() {
        Args args = new Args();
        args.add("--type");
        args.add(this.type);
        args.add("--line-break");
        args.add(String.valueOf(this.lineBreak));
        args.add("--charset");
        args.add(this.charset);
        if (this.verbose) {
            args.add("--verbose");
        }
        if (this.type.equalsIgnoreCase("js")) {
            if (this.nomunge) {
                args.add("--nomunge");
            }
            if (this.preserveSemi) {
                args.add("--preserve-semi");
            }
            if (this.disableOptimizations) {
                args.add("--disable-optimizations");
            }
        }
        return args;
    }

    protected boolean shouldBuild() {
        if (!this.outputFile.exists()) {
            return true;
        }
        long lastModified = this.outputFile.lastModified();
        for (File inputFile : this.inputFiles) {
            if (inputFile.lastModified() <= lastModified) continue;
            return true;
        }
        return false;
    }

    protected void buildInternal() throws Exception {
        if (this.outputFile.exists()) {
            FileUtils.deleteQuietly((File)this.outputFile);
        } else {
            this.outputFile.getParentFile().mkdirs();
        }
        if (this.inputFiles.size() == 1) {
            if (this.mergeOnly) {
                FileUtils.copyFile((File)this.inputFiles.get(0), (File)this.outputFile);
            } else {
                this.compressIfRequired(this.inputFiles.get(0), this.outputFile);
            }
            return;
        }
        if (this.mergeOnly) {
            YUIBuilder.mergeFiles(this.inputFiles, this.outputFile, false);
        } else {
            ArrayList<File> tempOutputFiles = new ArrayList<File>();
            for (File inputFile : this.inputFiles) {
                File tempOutputFile = File.createTempFile("op-YUIBuilder-", "." + this.type);
                tempOutputFiles.add(tempOutputFile);
                this.compressIfRequired(inputFile, tempOutputFile);
            }
            YUIBuilder.mergeFiles(tempOutputFiles, this.outputFile, true);
        }
    }

    private void compressIfRequired(File inputFile, File outputFile) throws Exception {
        if (inputFile.getName().endsWith(".min." + this.type)) {
            FileUtils.copyFile((File)inputFile, (File)outputFile);
        } else {
            try {
                this.compress(inputFile, outputFile);
            }
            catch (Exception e) {
                FileUtils.deleteQuietly((File)outputFile);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeFiles(List<File> inputFiles, File outputFile, boolean deleleInputFiles) throws IOException {
        FileOutputStream out = new FileOutputStream(outputFile, true);
        try {
            for (File inputFile : inputFiles) {
                FileUtils.copyFile((File)inputFile, (OutputStream)out);
                log.debug("Merge file '{}' to '{}'", (Object)inputFile, (Object)outputFile);
                if (!deleleInputFiles) continue;
                FileUtils.deleteQuietly((File)inputFile);
                log.debug("Delete file '{}'", (Object)inputFile);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void build() throws Exception {
        if (this.shouldBuild()) {
            this.buildInternal();
        } else {
            log.debug("Nothing to build - the output file '{}' is up to date.", (Object)this.outputFile);
        }
    }

    public void clean() throws Exception {
        if (this.outputFile != null && this.outputFile.exists()) {
            FileUtils.deleteQuietly((File)this.outputFile);
        }
    }

    public void initialize() throws Exception {
    }

    public void check() throws Exception {
        this.build();
    }

    public void destroy() throws Exception {
    }

    public String toString() {
        if (this.inputFiles == null || this.outputFile == null) {
            return super.toString();
        }
        return this.getClass().getSimpleName() + "('" + this.inputFiles + "' => '" + this.outputFile + "')";
    }

    public static class Args {
        private List<String> list = new ArrayList<String>();

        public Args add(String arg) {
            this.list.add(arg);
            return this;
        }

        public Args add(Object o) {
            this.list.add(o.toString());
            return this;
        }

        public String[] toArray() {
            return this.list.toArray(new String[this.list.size()]);
        }

        public String toString() {
            return this.list.toString();
        }
    }
}

