/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.source;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.monitor.FileEntry;
import org.opoo.press.SourceEntry;
import org.opoo.press.SourceEntryLoader;

public class SourceEntryLoaderImpl
implements SourceEntryLoader {
    public List<SourceEntry> loadSourceEntries(File sourcePath, FileFilter fileFilter) {
        ArrayList<SourceEntry> results = new ArrayList<SourceEntry>();
        this.listFileEntries(results, sourcePath, null, fileFilter);
        return results;
    }

    private void listFileEntries(List<SourceEntry> results, File parent, SourceEntry parentEntry, FileFilter fileFilter) {
        File[] files = parent.listFiles(fileFilter);
        SourceEntry[] children = new SourceEntry[files.length];
        for (int i = 0; i < files.length; ++i) {
            SourceEntry child;
            File file = files[i];
            children[i] = child = new SourceEntry(parentEntry, file);
            if (file.isFile()) {
                results.add(child);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.listFileEntries(results, file, child, fileFilter);
        }
        if (parentEntry != null) {
            parentEntry.setChildren((FileEntry[])children);
        }
    }

    public SourceEntry buildSourceEntry(File root, File file) {
        ArrayList<File> files = new ArrayList<File>();
        File parent = file.getParentFile();
        if (parent == null) {
            throw new IllegalArgumentException("Directory must contains file");
        }
        while (!parent.equals(root)) {
            files.add(parent);
            parent = parent.getParentFile();
        }
        SourceEntry parentEntry = null;
        if (!files.isEmpty()) {
            Collections.reverse(files);
            Iterator iterator = files.iterator();
            parentEntry = new SourceEntry((File)iterator.next());
            while (iterator.hasNext()) {
                parentEntry = new SourceEntry(parentEntry, (File)iterator.next());
            }
        }
        return new SourceEntry(parentEntry, file);
    }
}

