/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.template;

import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModelException;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.opoo.press.Config;
import org.opoo.press.ConfigAware;
import org.opoo.press.Named;

public class TitleCaseModel
implements TemplateMethodModel,
Named,
ConfigAware {
    private static String[] smallWords = new String[]{"a", "an", "am", "and", "as", "at", "but", "by", "en", "for", "if", "in", "of", "on", "or", "the", "to", "v", "v.", "via", "vs", "vs.", "be"};
    private static List<String> smallWordList = Arrays.asList(smallWords);
    private boolean titlecase;

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments == null || arguments.isEmpty()) {
            return "";
        }
        String str = (String)arguments.get(0);
        return this.titlecase ? TitleCaseModel.toTitleCase(str) : str;
    }

    public String getName() {
        return "titlecase";
    }

    public void setConfig(Config config) {
        if (config != null) {
            this.titlecase = (Boolean)config.get("titlecase", (Object)false);
        }
    }

    public static String toTitleCase(String string) {
        StringTokenizer st = new StringTokenizer(string);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            String str = st.nextToken();
            String lower = str.toLowerCase();
            if (sb.length() > 0 && smallWordList.contains(lower)) {
                sb.append(lower);
                continue;
            }
            sb.append((str.charAt(0) + "").toUpperCase());
            if (str.length() <= 1) continue;
            sb.append(str.substring(1));
        }
        return sb.toString();
    }
}

