/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.util;

import org.opoo.press.Config;
import org.opoo.press.ConfigAware;
import org.opoo.press.Site;
import org.opoo.press.SiteAware;

public abstract class ClassUtils
extends org.apache.commons.lang.ClassUtils {
    public static <T> T newInstance(String className, Site site) {
        return ClassUtils.newInstance(className, null, site, site != null ? site.getConfig() : null);
    }

    public static <T> T newInstance(String className, Config config) {
        return ClassUtils.newInstance(className, null, null, config);
    }

    public static <T> T newInstance(String className) {
        return ClassUtils.newInstance(className, (ClassLoader)null);
    }

    public static <T> T newInstance(String className, ClassLoader classLoader) {
        return ClassUtils.newInstance(className, classLoader, null, null);
    }

    public static <T> T newInstance(String className, ClassLoader classLoader, Site site, Config config) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        T instance = null;
        try {
            Class clazz = ClassUtils.getClass((ClassLoader)classLoader, (String)className);
            instance = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Create instance failed: " + className, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Create instance failed: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Create instance failed: " + className, e);
        }
        if (instance instanceof SiteAware) {
            ((SiteAware)instance).setSite(site);
        }
        if (instance instanceof ConfigAware) {
            ((ConfigAware)instance).setConfig(config);
        }
        return instance;
    }
}

