/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.util;

import java.io.Externalizable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.opoo.press.Site;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaleUtils {
    private static final Logger log = LoggerFactory.getLogger(StaleUtils.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    static File getLastBuildInfoFile(Site site) {
        return new File(site.getWorking(), ".lastBuildInfo");
    }

    public static void saveLastBuildInfo(Site site) {
        File file = StaleUtils.getLastBuildInfoFile(site);
        File[] configFiles = site.getConfig().getConfigFiles();
        BuildInfo info = new BuildInfo();
        info.time = System.currentTimeMillis();
        info.siteConfigFilesLength = configFiles.length;
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(info);
            oos.flush();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)oos);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BuildInfo getLastBuildInfo(Site site) {
        BuildInfo buildInfo;
        File file = StaleUtils.getLastBuildInfoFile(site);
        if (!file.exists()) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(file));
            buildInfo = (BuildInfo)ois.readObject();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
                catch (ClassNotFoundException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        return buildInfo;
    }

    public static boolean isStale(Site site) {
        return StaleUtils.isStale(site, false);
    }

    public static boolean isStale(Site site, boolean checkAssets) {
        List assets;
        BuildInfo info = StaleUtils.getLastBuildInfo(site);
        if (info == null || info.time <= 0L) {
            log.debug("No last build info.");
            return true;
        }
        if (site.showDrafts() != info.showDrafts) {
            log.info("Show drafts option changed: {} -> {}", (Object)info.showDrafts, (Object)site.showDrafts());
            return true;
        }
        long lastBuildTime = info.time;
        if (site.getTheme().getConfigFile().lastModified() > lastBuildTime) {
            log.info("Theme configuration file changed: {}", (Object)site.getTheme().getConfigFile());
            return true;
        }
        File[] configFiles = site.getConfig().getConfigFiles();
        if (info.siteConfigFilesLength != configFiles.length) {
            log.info("Site configuration files changed.");
            return true;
        }
        for (File file : configFiles) {
            if (file.lastModified() <= lastBuildTime) continue;
            log.info("Site configuration file changed: {}", (Object)file);
            return true;
        }
        ValidFileFilter filter = new ValidFileFilter();
        List sources = site.getSources();
        for (File source : sources) {
            if (!StaleUtils.isNewer(source, lastBuildTime, filter)) continue;
            log.info("Source file changed.");
            return true;
        }
        File templates = site.getTemplates();
        if (StaleUtils.isNewer(templates, lastBuildTime, filter)) {
            log.info("Template file changed.");
            return true;
        }
        if (checkAssets && (assets = site.getAssets()) != null && !assets.isEmpty()) {
            for (File asset : assets) {
                if (!StaleUtils.isNewer(asset, lastBuildTime, filter)) continue;
                log.info("Asset file changed.");
                return true;
            }
        }
        return false;
    }

    public static List<File> getStaleAssets(Site site) {
        BuildInfo info = StaleUtils.getLastBuildInfo(site);
        long lastBuildTime = info.time;
        ValidFileFilter filter = new ValidFileFilter();
        ArrayList<File> list = new ArrayList<File>();
        List assets = site.getAssets();
        if (assets != null && !assets.isEmpty()) {
            for (File asset : assets) {
                if (!StaleUtils.isNewer(asset, lastBuildTime, filter)) continue;
                list.add(asset);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public static boolean isNewer(File dir, long compareTime, FileFilter filter) {
        File[] listFiles;
        for (File file : listFiles = dir.listFiles(filter)) {
            if (file.isHidden()) {
                log.debug("Skip check hidden file: " + file);
                continue;
            }
            if (file.isFile()) {
                if (file.lastModified() <= compareTime) continue;
                log.info("File {} changed.", (Object)file);
                return true;
            }
            if (!file.isDirectory() || !StaleUtils.isNewer(file, compareTime, filter)) continue;
            return true;
        }
        return false;
    }

    public static String format(long millis) {
        return SDF.format(new Date(millis));
    }

    public static class BuildInfo
    implements Externalizable {
        private long time;
        private boolean showDrafts;
        private int siteConfigFilesLength;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.time);
            out.writeBoolean(this.showDrafts);
            out.writeInt(this.siteConfigFilesLength);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.time = in.readLong();
            this.showDrafts = in.readBoolean();
            this.siteConfigFilesLength = in.readInt();
        }
    }

    private static class ValidFileFilter
    implements FileFilter {
        private ValidFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            char firstChar = name.charAt(0);
            if (firstChar == '.' || firstChar == '#') {
                return false;
            }
            char lastChar = name.charAt(name.length() - 1);
            return lastChar != '~';
        }
    }
}

