/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NUtills {
    private static final Object[] NO_ARGS = new Object[0];

    public static String getString(String bundleName, Locale locale, String key) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale);
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static String format(String bundleName, Locale locale, String key, Object arg1) {
        return I18NUtills.format(bundleName, locale, key, new Object[]{arg1});
    }

    public static String format(String bundleName, Locale locale, String key, Object arg1, Object arg2) {
        return I18NUtills.format(bundleName, locale, key, new Object[]{arg1, arg2});
    }

    public static String format(String bundleName, Locale locale, String key, Object[] args) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String value = I18NUtills.getString(bundleName, locale, key);
        if (args == null) {
            args = NO_ARGS;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(value);
        return messageFormat.format(args);
    }
}

