/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public abstract class PathUtils {
    public static void checkDir(File dir, Strategy p) {
        if (!dir.exists()) {
            if (p == Strategy.CREATE_IF_NOT_EXISTS) {
                dir.mkdirs();
            } else if (p == Strategy.THROW_EXCEPTION_IF_NOT_EXISTS) {
                throw new IllegalArgumentException("Directory not exits: " + dir);
            }
        } else if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Path exits but not a directory: " + dir);
        }
        if (Strategy.CREATE_ALWAYS == p) {
            if (dir.exists()) {
                FileUtils.deleteQuietly((File)dir);
            }
            dir.mkdirs();
        }
    }

    public static void checkFile(File file, Strategy p) {
        if (!file.exists()) {
            if (Strategy.CREATE_IF_NOT_EXISTS == p) {
                file.getParentFile().mkdirs();
            } else if (Strategy.THROW_EXCEPTION_IF_NOT_EXISTS == p) {
                throw new IllegalArgumentException("File not exits: " + file);
            }
        } else if (!file.isFile()) {
            throw new IllegalArgumentException("Path exits but not a file: " + file);
        }
        if (Strategy.CREATE_ALWAYS == p) {
            if (file.exists()) {
                FileUtils.deleteQuietly((File)file);
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
        }
    }

    public static File canonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isValidDirectory(File dir) {
        return dir != null && dir.exists() && dir.isDirectory() && dir.canRead();
    }

    public static File appendBaseIfNotAbsolute(File basedir, String name) {
        File tmp;
        File file = null;
        if (FilenameUtils.separatorsToUnix((String)name).indexOf(47) != -1 && (tmp = new File(name)).isAbsolute()) {
            file = tmp;
        }
        if (file == null) {
            file = new File(basedir, name);
        }
        return PathUtils.canonical(file);
    }

    public static List<File> listFiles(File dir, FileFilter filter, boolean recursive) {
        ArrayList<File> list = new ArrayList<File>();
        PathUtils.listFilesInternal(list, dir, filter, recursive);
        return list;
    }

    private static void listFilesInternal(List<File> list, File dir, FileFilter filter, boolean recursive) {
        String[] ss = dir.list();
        if (ss == null) {
            return;
        }
        for (String s : ss) {
            File f = new File(dir, s);
            if (f.isFile() && (filter == null || filter.accept(f))) {
                list.add(f);
            }
            if (!recursive || !f.isDirectory()) continue;
            PathUtils.listFilesInternal(list, f, filter, recursive);
        }
    }

    public static List<File> listFiles(File dir, FilenameFilter filter, boolean recursive) {
        ArrayList<File> list = new ArrayList<File>();
        PathUtils.listFilesInternal(list, dir, filter, recursive);
        return list;
    }

    private static void listFilesInternal(List<File> list, File dir, FilenameFilter filter, boolean recursive) {
        String[] ss = dir.list();
        if (ss == null) {
            return;
        }
        for (String s : ss) {
            File f = new File(dir, s);
            if (f.isFile() && (filter == null || filter.accept(dir, s))) {
                list.add(f);
            }
            if (!recursive || !f.isDirectory()) continue;
            PathUtils.listFilesInternal(list, f, filter, recursive);
        }
    }

    public static enum Strategy {
        NONE,
        CREATE_IF_NOT_EXISTS,
        THROW_EXCEPTION_IF_NOT_EXISTS,
        CREATE_ALWAYS;

    }
}

