/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.improvingsteppercentage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.benchmark.impl.statistic.AbstractSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.improvingsteppercentage.ImprovingStepPercentageSingleStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.solver.DefaultSolver;

public class ImprovingStepPercentageSingleStatistic
extends AbstractSingleStatistic {
    private final long timeMillisThresholdInterval;
    private long nextTimeMillisThreshold;
    private final ImprovingStepPercentageSingleStatisticListener listener = new ImprovingStepPercentageSingleStatisticListener();
    private final Map<Class<? extends Move>, List<ImprovingStepPercentageSingleStatisticPoint>> pointLists = new HashMap<Class<? extends Move>, List<ImprovingStepPercentageSingleStatisticPoint>>();

    public ImprovingStepPercentageSingleStatistic() {
        this(1000L);
    }

    public ImprovingStepPercentageSingleStatistic(long timeMillisThresholdInterval) {
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
        this.nextTimeMillisThreshold = timeMillisThresholdInterval;
    }

    public Map<Class<? extends Move>, List<ImprovingStepPercentageSingleStatisticPoint>> getPointLists() {
        return this.pointLists;
    }

    @Override
    public void open(Solver solver) {
        ((DefaultSolver)solver).addSolverPhaseLifecycleListener((SolverPhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver solver) {
        ((DefaultSolver)solver).removeSolverPhaseLifecycleListener((SolverPhaseLifecycleListener)this.listener);
    }

    private class ImprovingStepPercentageSingleStatisticListener
    extends SolverPhaseLifecycleListenerAdapter {
        private final Map<Class<? extends Move>, Integer> improvementCounts = new HashMap<Class<? extends Move>, Integer>();
        private final Map<Class<? extends Move>, Integer> totalCounts = new HashMap<Class<? extends Move>, Integer>();

        private ImprovingStepPercentageSingleStatisticListener() {
        }

        private void increaseByOne(Map<Class<? extends Move>, Integer> where, Class<? extends Move> what) {
            if (!where.containsKey(what)) {
                where.put(what, 1);
            } else {
                where.put(what, where.get(what) + 1);
            }
        }

        private void addPoint(Class<? extends Move> where, ImprovingStepPercentageSingleStatisticPoint what) {
            if (!ImprovingStepPercentageSingleStatistic.this.pointLists.containsKey(where)) {
                ImprovingStepPercentageSingleStatistic.this.pointLists.put(where, new ArrayList());
            }
            ((List)ImprovingStepPercentageSingleStatistic.this.pointLists.get(where)).add(what);
        }

        private void localSearchStepEnded(LocalSearchStepScope stepScope) {
            long timeMillisSpend;
            Move step = stepScope.getStep();
            Class<?> moveType = step.getClass();
            this.increaseByOne(this.totalCounts, moveType);
            if (stepScope.getBestScoreImproved().booleanValue()) {
                this.increaseByOne(this.improvementCounts, moveType);
            }
            if ((timeMillisSpend = stepScope.getPhaseScope().calculateSolverTimeMillisSpend()) < ImprovingStepPercentageSingleStatistic.this.nextTimeMillisThreshold) {
                return;
            }
            for (Map.Entry<Class<? extends Move>, Integer> entry : this.totalCounts.entrySet()) {
                Class<? extends Move> moveClass = entry.getKey();
                double improved = this.improvementCounts.containsKey(moveClass) ? (double)this.improvementCounts.get(moveClass).intValue() : 0.0;
                double total = entry.getValue().intValue();
                double ratio = improved / total;
                this.addPoint(moveClass, new ImprovingStepPercentageSingleStatisticPoint(timeMillisSpend, ratio));
            }
            this.improvementCounts.clear();
            this.totalCounts.clear();
            ImprovingStepPercentageSingleStatistic.this.nextTimeMillisThreshold += ImprovingStepPercentageSingleStatistic.this.timeMillisThresholdInterval;
            if (ImprovingStepPercentageSingleStatistic.this.nextTimeMillisThreshold < timeMillisSpend) {
                ImprovingStepPercentageSingleStatistic.this.nextTimeMillisThreshold = timeMillisSpend;
            }
        }

        public void stepEnded(AbstractStepScope stepScope) {
            if (stepScope instanceof LocalSearchStepScope) {
                this.localSearchStepEnded((LocalSearchStepScope)stepScope);
            }
        }
    }
}

