/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.core.config.solver.XmlSolverFactory;

public class XmlPlannerBenchmarkFactory
implements PlannerBenchmarkFactory {
    private XStream xStream = XmlSolverFactory.buildXstream();
    private PlannerBenchmarkConfig plannerBenchmarkConfig = null;

    public XmlPlannerBenchmarkFactory() {
        this.xStream.processAnnotations(PlannerBenchmarkConfig.class);
    }

    public XmlPlannerBenchmarkFactory(String benchmarkConfigResource) {
        this();
        this.configure(benchmarkConfigResource);
    }

    public void addXstreamAnnotations(Class ... xstreamAnnotations) {
        this.xStream.processAnnotations(xstreamAnnotations);
    }

    public XmlPlannerBenchmarkFactory configure(String benchmarkConfigResource) {
        InputStream in = this.getClass().getResourceAsStream(benchmarkConfigResource);
        if (in == null) {
            throw new IllegalArgumentException("The benchmarkConfigResource (" + benchmarkConfigResource + ") does not exist in the classpath.");
        }
        try {
            return this.configure(in);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Unmarshalling of benchmarkConfigResource (" + benchmarkConfigResource + ") fails.", e);
        }
    }

    public XmlPlannerBenchmarkFactory configure(InputStream in) {
        XmlPlannerBenchmarkFactory xmlPlannerBenchmarkFactory;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, "UTF-8");
            xmlPlannerBenchmarkFactory = this.configure(reader);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)in);
        return xmlPlannerBenchmarkFactory;
    }

    public XmlPlannerBenchmarkFactory configure(Reader reader) {
        this.plannerBenchmarkConfig = (PlannerBenchmarkConfig)this.xStream.fromXML(reader);
        return this;
    }

    @Override
    public PlannerBenchmarkConfig getPlannerBenchmarkConfig() {
        if (this.plannerBenchmarkConfig == null) {
            throw new IllegalStateException("The plannerBenchmarkConfig (" + this.plannerBenchmarkConfig + ") is null," + " call configure(...) first.");
        }
        return this.plannerBenchmarkConfig;
    }

    @Override
    public PlannerBenchmark buildPlannerBenchmark() {
        if (this.plannerBenchmarkConfig == null) {
            throw new IllegalStateException("The plannerBenchmarkConfig (" + this.plannerBenchmarkConfig + ") is null," + " call configure(...) first.");
        }
        return this.plannerBenchmarkConfig.buildPlannerBenchmark();
    }
}

