/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.ranking;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.benchmark.impl.ranking.AbstractSolverRankingComparatorTest;
import org.optaplanner.benchmark.impl.ranking.TotalRankSolverRankingWeightFactory;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;

public class TotalRankSolverRankingWeightFactoryTest
extends AbstractSolverRankingComparatorTest {
    @Test
    public void normal() {
        BenchmarkReport benchmarkReport = (BenchmarkReport)Mockito.mock(BenchmarkReport.class);
        TotalRankSolverRankingWeightFactory factory = new TotalRankSolverRankingWeightFactory();
        ArrayList<SolverBenchmarkResult> solverBenchmarkResultList = new ArrayList<SolverBenchmarkResult>();
        SolverBenchmarkResult a = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> aSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmark(aSingleBenchmarkResultList, -1000, -40, -1000);
        this.addSingleBenchmark(aSingleBenchmarkResultList, -300, -40, -1000);
        this.addSingleBenchmark(aSingleBenchmarkResultList, -40, -40, -1000);
        a.setSingleBenchmarkResultList(aSingleBenchmarkResultList);
        a.accumulateResults(benchmarkReport);
        solverBenchmarkResultList.add(a);
        SolverBenchmarkResult b = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> bSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmark(bSingleBenchmarkResultList, -2000, -30, -2000);
        this.addSingleBenchmark(bSingleBenchmarkResultList, -200, -30, -2000);
        this.addSingleBenchmark(bSingleBenchmarkResultList, -30, -30, -2000);
        b.setSingleBenchmarkResultList(bSingleBenchmarkResultList);
        b.accumulateResults(benchmarkReport);
        solverBenchmarkResultList.add(b);
        Comparable aWeight = factory.createRankingWeight(solverBenchmarkResultList, a);
        Comparable bWeight = factory.createRankingWeight(solverBenchmarkResultList, b);
        Assert.assertEquals((long)-1L, (long)aWeight.compareTo(bWeight));
        Assert.assertEquals((long)1L, (long)bWeight.compareTo(aWeight));
    }

    @Test
    public void equalCount() {
        BenchmarkReport benchmarkReport = (BenchmarkReport)Mockito.mock(BenchmarkReport.class);
        TotalRankSolverRankingWeightFactory factory = new TotalRankSolverRankingWeightFactory();
        ArrayList<SolverBenchmarkResult> solverBenchmarkResultList = new ArrayList<SolverBenchmarkResult>();
        SolverBenchmarkResult a = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> aSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmark(aSingleBenchmarkResultList, -5000, -90, -5000);
        this.addSingleBenchmark(aSingleBenchmarkResultList, -900, -90, -5000);
        this.addSingleBenchmark(aSingleBenchmarkResultList, -90, -90, -5000);
        a.setSingleBenchmarkResultList(aSingleBenchmarkResultList);
        a.accumulateResults(benchmarkReport);
        solverBenchmarkResultList.add(a);
        SolverBenchmarkResult b = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> bSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmark(bSingleBenchmarkResultList, -1000, -20, -1000);
        this.addSingleBenchmark(bSingleBenchmarkResultList, -200, -20, -1000);
        this.addSingleBenchmark(bSingleBenchmarkResultList, -20, -20, -1000);
        b.setSingleBenchmarkResultList(bSingleBenchmarkResultList);
        b.accumulateResults(benchmarkReport);
        solverBenchmarkResultList.add(b);
        SolverBenchmarkResult c = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> cSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmark(cSingleBenchmarkResultList, -5000, -10, -5000);
        this.addSingleBenchmark(cSingleBenchmarkResultList, -100, -10, -5000);
        this.addSingleBenchmark(cSingleBenchmarkResultList, -10, -10, -5000);
        c.setSingleBenchmarkResultList(cSingleBenchmarkResultList);
        c.accumulateResults(benchmarkReport);
        solverBenchmarkResultList.add(c);
        Comparable aWeight = factory.createRankingWeight(solverBenchmarkResultList, a);
        Comparable bWeight = factory.createRankingWeight(solverBenchmarkResultList, b);
        Comparable cWeight = factory.createRankingWeight(solverBenchmarkResultList, c);
        Assert.assertEquals((long)-1L, (long)aWeight.compareTo(bWeight));
        Assert.assertEquals((long)1L, (long)bWeight.compareTo(aWeight));
        Assert.assertEquals((long)-1L, (long)aWeight.compareTo(cWeight));
        Assert.assertEquals((long)1L, (long)cWeight.compareTo(aWeight));
        Assert.assertEquals((long)-1L, (long)bWeight.compareTo(cWeight));
        Assert.assertEquals((long)1L, (long)cWeight.compareTo(bWeight));
    }
}

