/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.ranking;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.benchmark.impl.ranking.AbstractSolverRankingComparatorTest;
import org.optaplanner.benchmark.impl.ranking.WorstScoreSolverRankingComparator;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;

public class WorstScoreSolverRankingComparatorTest
extends AbstractSolverRankingComparatorTest {
    @Test
    public void normal() {
        BenchmarkReport benchmarkReport = (BenchmarkReport)Mockito.mock(BenchmarkReport.class);
        WorstScoreSolverRankingComparator comparator = new WorstScoreSolverRankingComparator();
        SolverBenchmarkResult a = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> aSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmark(aSingleBenchmarkResultList, -100, -30, -2001);
        this.addSingleBenchmark(aSingleBenchmarkResultList, -2001, -30, -2001);
        this.addSingleBenchmark(aSingleBenchmarkResultList, -30, -30, -2001);
        a.setSingleBenchmarkResultList(aSingleBenchmarkResultList);
        a.accumulateResults(benchmarkReport);
        SolverBenchmarkResult b = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> bSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmark(bSingleBenchmarkResultList, -900, -30, -2000);
        this.addSingleBenchmark(bSingleBenchmarkResultList, -2000, -30, -2000);
        this.addSingleBenchmark(bSingleBenchmarkResultList, -30, -30, -2000);
        b.setSingleBenchmarkResultList(bSingleBenchmarkResultList);
        b.accumulateResults(benchmarkReport);
        Assert.assertEquals((long)-1L, (long)comparator.compare(a, b));
        Assert.assertEquals((long)1L, (long)comparator.compare(b, a));
    }

    @Test
    public void worstIsEqual() {
        BenchmarkReport benchmarkReport = (BenchmarkReport)Mockito.mock(BenchmarkReport.class);
        WorstScoreSolverRankingComparator comparator = new WorstScoreSolverRankingComparator();
        SolverBenchmarkResult a = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> aSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmark(aSingleBenchmarkResultList, -101, -30, -2000);
        this.addSingleBenchmark(aSingleBenchmarkResultList, -2000, -30, -2000);
        this.addSingleBenchmark(aSingleBenchmarkResultList, -30, -30, -2000);
        a.setSingleBenchmarkResultList(aSingleBenchmarkResultList);
        a.accumulateResults(benchmarkReport);
        SolverBenchmarkResult b = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> bSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmark(bSingleBenchmarkResultList, -100, -40, -2000);
        this.addSingleBenchmark(bSingleBenchmarkResultList, -2000, -40, -2000);
        this.addSingleBenchmark(bSingleBenchmarkResultList, -40, -40, -2000);
        b.setSingleBenchmarkResultList(bSingleBenchmarkResultList);
        b.accumulateResults(benchmarkReport);
        Assert.assertEquals((long)-1L, (long)comparator.compare(a, b));
        Assert.assertEquals((long)1L, (long)comparator.compare(b, a));
    }

    @Test
    public void differentScoreDefinitions() {
        BenchmarkReport benchmarkReport = (BenchmarkReport)Mockito.mock(BenchmarkReport.class);
        WorstScoreSolverRankingComparator comparator = new WorstScoreSolverRankingComparator();
        SolverBenchmarkResult a = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> aSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmark(aSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(aSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(aSingleBenchmarkResultList, -30, -30, -1000);
        a.setSingleBenchmarkResultList(aSingleBenchmarkResultList);
        a.accumulateResults(benchmarkReport);
        SolverBenchmarkResult b = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> bSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmarkWithHardSoftLongScore(bSingleBenchmarkResultList, 0L, -1000L, 0L, -50L, -10L, -1000L);
        this.addSingleBenchmarkWithHardSoftLongScore(bSingleBenchmarkResultList, 0L, -200L, 0L, -50L, -10L, -1000L);
        this.addSingleBenchmarkWithHardSoftLongScore(bSingleBenchmarkResultList, -7L, -50L, 0L, -50L, -10L, -1000L);
        b.setSingleBenchmarkResultList(bSingleBenchmarkResultList);
        b.accumulateResults(benchmarkReport);
        Assert.assertEquals((long)-1L, (long)comparator.compare(a, b));
        Assert.assertEquals((long)1L, (long)comparator.compare(b, a));
    }
}

