/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.aggregator.swingui;

import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingUtils {
    private static final Logger logger = LoggerFactory.getLogger(SwingUtils.class);

    public static void fixateLookAndFeel() {
        Exception lookAndFeelException;
        String lookAndFeelName = "Metal";
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!lookAndFeelName.equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                return;
            }
            lookAndFeelException = null;
        }
        catch (UnsupportedLookAndFeelException e) {
            lookAndFeelException = e;
        }
        catch (ClassNotFoundException e) {
            lookAndFeelException = e;
        }
        catch (InstantiationException e) {
            lookAndFeelException = e;
        }
        catch (IllegalAccessException e) {
            lookAndFeelException = e;
        }
        logger.warn("Could not switch to lookAndFeel (" + lookAndFeelName + "). Layout might be incorrect.", (Throwable)lookAndFeelException);
    }

    private SwingUtils() {
    }
}

