/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.util.concurrent.Callable;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleBenchmarkRunner
implements Callable<SingleBenchmarkRunner> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SingleBenchmarkResult singleBenchmarkResult;
    private Throwable failureThrowable = null;

    public SingleBenchmarkRunner(SingleBenchmarkResult singleBenchmarkResult) {
        this.singleBenchmarkResult = singleBenchmarkResult;
    }

    public SingleBenchmarkResult getSingleBenchmarkResult() {
        return this.singleBenchmarkResult;
    }

    public Throwable getFailureThrowable() {
        return this.failureThrowable;
    }

    public void setFailureThrowable(Throwable failureThrowable) {
        this.failureThrowable = failureThrowable;
    }

    @Override
    public SingleBenchmarkRunner call() {
        Runtime runtime = Runtime.getRuntime();
        ProblemBenchmarkResult problemBenchmarkResult = this.singleBenchmarkResult.getProblemBenchmarkResult();
        Solution inputSolution = problemBenchmarkResult.readPlanningProblem();
        if (!problemBenchmarkResult.getPlannerBenchmarkResult().hasMultipleParallelBenchmarks()) {
            runtime.gc();
            this.singleBenchmarkResult.setUsedMemoryAfterInputSolution(runtime.totalMemory() - runtime.freeMemory());
        }
        this.logger.trace("Benchmark inputSolution has been read for singleBenchmarkResult ({}).", (Object)this.singleBenchmarkResult.getName());
        Solver solver = this.singleBenchmarkResult.getSolverBenchmarkResult().getSolverConfig().buildSolver();
        for (SingleStatistic singleStatistic : this.singleBenchmarkResult.getEffectiveSingleStatisticMap().values()) {
            singleStatistic.open(solver);
        }
        solver.solve(inputSolution);
        long timeMillisSpent = solver.getTimeMillisSpent();
        Solution outputSolution = solver.getBestSolution();
        DefaultSolverScope solverScope = ((DefaultSolver)solver).getSolverScope();
        SolutionDescriptor solutionDescriptor = solverScope.getSolutionDescriptor();
        problemBenchmarkResult.registerScale(solutionDescriptor.getEntityCount(outputSolution), solutionDescriptor.getVariableCount(outputSolution), solutionDescriptor.getProblemScale(outputSolution));
        this.singleBenchmarkResult.setScore(outputSolution.getScore());
        this.singleBenchmarkResult.setTimeMillisSpent(timeMillisSpent);
        this.singleBenchmarkResult.setCalculateCount(solverScope.getCalculateCount());
        for (SingleStatistic singleStatistic : this.singleBenchmarkResult.getEffectiveSingleStatisticMap().values()) {
            singleStatistic.close(solver);
            singleStatistic.writeCsvStatisticFile();
        }
        problemBenchmarkResult.writeOutputSolution(this.singleBenchmarkResult, outputSolution);
        return this;
    }

    public String getName() {
        return this.singleBenchmarkResult.getName();
    }

    public String toString() {
        return this.singleBenchmarkResult.toString();
    }
}

