/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.pickedmovetypestepscore;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.YIntervalRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.PureSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.common.MillisecondsSpentNumberFormat;
import org.optaplanner.benchmark.impl.statistic.pickedmovetypestepscore.PickedMoveTypeStepScoreDiffStatisticPoint;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.ScoreUtils;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.DefaultSolver;

@XStreamAlias(value="pickedMoveTypeStepScoreDiffSingleStatistic")
public class PickedMoveTypeStepScoreDiffSingleStatistic
extends PureSingleStatistic<PickedMoveTypeStepScoreDiffStatisticPoint> {
    @XStreamOmitField
    private PickedMoveTypeStepScoreDiffSingleStatisticListener listener = new PickedMoveTypeStepScoreDiffSingleStatisticListener();
    @XStreamOmitField
    protected List<File> graphFileList = null;

    public PickedMoveTypeStepScoreDiffSingleStatistic(SingleBenchmarkResult singleBenchmarkResult) {
        super(singleBenchmarkResult, SingleStatisticType.PICKED_MOVE_TYPE_STEP_SCORE_DIFF);
    }

    public List<File> getGraphFileList() {
        return this.graphFileList;
    }

    @Override
    public void open(Solver solver) {
        ((DefaultSolver)solver).addPhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver solver) {
        ((DefaultSolver)solver).removePhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return PickedMoveTypeStepScoreDiffStatisticPoint.buildCsvLine("timeMillisSpent", "moveType", "stepScoreDiff");
    }

    @Override
    protected PickedMoveTypeStepScoreDiffStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new PickedMoveTypeStepScoreDiffStatisticPoint(Long.valueOf(csvLine.get(0)), csvLine.get(1), scoreDefinition.parseScore(csvLine.get(2)));
    }

    @Override
    public void writeGraphFiles(BenchmarkReport benchmarkReport) {
        ArrayList moveTypeToSeriesMapList = new ArrayList(5);
        for (PickedMoveTypeStepScoreDiffStatisticPoint point : this.getPointList()) {
            long timeMillisSpent = point.getTimeMillisSpent();
            String moveType = point.getMoveType();
            double[] levelValues = ScoreUtils.extractLevelDoubles((Score)point.getStepScoreDiff());
            for (int i = 0; i < levelValues.length && i < 5; ++i) {
                Map moveTypeToSeriesMap;
                XYIntervalSeries series;
                if (i >= moveTypeToSeriesMapList.size()) {
                    moveTypeToSeriesMapList.add(new LinkedHashMap());
                }
                if ((series = (XYIntervalSeries)(moveTypeToSeriesMap = (Map)moveTypeToSeriesMapList.get(i)).get(moveType)) == null) {
                    series = new XYIntervalSeries((Comparable)((Object)moveType));
                    moveTypeToSeriesMap.put(moveType, series);
                }
                double yValue = levelValues[i];
                series.add((double)timeMillisSpent, (double)timeMillisSpent, (double)timeMillisSpent, yValue, yValue > 0.0 ? 0.0 : yValue, yValue > 0.0 ? yValue : 0.0);
            }
        }
        this.graphFileList = new ArrayList<File>(moveTypeToSeriesMapList.size());
        for (int scoreLevelIndex = 0; scoreLevelIndex < moveTypeToSeriesMapList.size(); ++scoreLevelIndex) {
            XYPlot plot = this.createPlot(benchmarkReport, scoreLevelIndex);
            YIntervalRenderer renderer = new YIntervalRenderer();
            plot.setRenderer((XYItemRenderer)renderer);
            XYIntervalSeriesCollection seriesCollection = new XYIntervalSeriesCollection();
            for (XYIntervalSeries series : ((Map)moveTypeToSeriesMapList.get(scoreLevelIndex)).values()) {
                seriesCollection.addSeries(series);
            }
            plot.setDataset((XYDataset)seriesCollection);
            JFreeChart chart = new JFreeChart(this.singleBenchmarkResult.getName() + " picked move type step score diff level " + scoreLevelIndex + " statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.graphFileList.add(this.writeChartToImageFile(chart, "PickedMoveTypeStepScoreDiffStatisticLevel" + scoreLevelIndex));
        }
    }

    private XYPlot createPlot(BenchmarkReport benchmarkReport, int scoreLevelIndex) {
        Locale locale = benchmarkReport.getLocale();
        NumberAxis xAxis = new NumberAxis("Time spent");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpentNumberFormat(locale));
        NumberAxis yAxis = new NumberAxis("Step score diff level " + scoreLevelIndex);
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        yAxis.setAutoRangeIncludesZero(true);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }

    private class PickedMoveTypeStepScoreDiffSingleStatisticListener
    extends PhaseLifecycleListenerAdapter {
        private Score oldStepScore = null;

        private PickedMoveTypeStepScoreDiffSingleStatisticListener() {
        }

        public void phaseStarted(AbstractPhaseScope phaseScope) {
            if (phaseScope instanceof LocalSearchPhaseScope) {
                this.oldStepScore = phaseScope.getStartingScore();
            }
        }

        public void phaseEnded(AbstractPhaseScope phaseScope) {
            if (phaseScope instanceof LocalSearchPhaseScope) {
                this.oldStepScore = null;
            }
        }

        public void stepEnded(AbstractStepScope stepScope) {
            if (stepScope instanceof LocalSearchStepScope) {
                this.localSearchStepEnded((LocalSearchStepScope)stepScope);
            }
        }

        private void localSearchStepEnded(LocalSearchStepScope stepScope) {
            long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpent();
            String moveType = stepScope.getStep().getSimpleMoveTypeDescription();
            Score newStepScore = stepScope.getScore();
            Score stepScoreDiff = newStepScore.subtract(this.oldStepScore);
            this.oldStepScore = newStepScore;
            PickedMoveTypeStepScoreDiffSingleStatistic.this.pointList.add(new PickedMoveTypeStepScoreDiffStatisticPoint(timeMillisSpent, moveType, stepScoreDiff));
        }
    }
}

