/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import org.junit.Ignore;
import org.junit.Test;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;

public class SolverBenchmarkConfigTest {
    @Test
    public void validNameWithUnderscoreAndSpace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Valid_name with space_and_underscore");
        config.validate();
    }

    @Test
    @Ignore(value="PLANNER-348 is not in Java 6 (only in Java 7 or higher). See PlannerBenchmarkConfig.VALID_NAME_PATTERN")
    public void validNameWithJapanese() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Valid name (\u6709\u52b9\u540d in Japanese)");
        config.validate();
    }

    @Test(expected=IllegalStateException.class)
    public void invalidNameWithSlash() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("slash/name");
        config.validate();
    }

    @Test(expected=IllegalStateException.class)
    public void invalidNameWithSuffixWhitespace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Suffixed with space ");
        config.validate();
    }

    @Test(expected=IllegalStateException.class)
    public void invalidNameWithPrefixWhitespace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName(" prefixed with space");
        config.validate();
    }
}

