/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.api;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.core.api.solver.DivertingClassLoader;

public class PlannerBenchmarkFactoryTest {
    @BeforeClass
    public static void setup() throws IOException {
        File benchmarkTestDir = new File("target/benchmarkTest/");
        benchmarkTestDir.mkdirs();
        new File(benchmarkTestDir, "input.xml").createNewFile();
        new File(benchmarkTestDir, "output/").mkdir();
    }

    @Test
    public void testdataPlannerBenchmarkConfig() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/testdataPlannerBenchmarkConfig.xml");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
    }

    @Test
    public void testdataPlannerBenchmarkConfigBenchmark() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/testdataPlannerBenchmarkConfig.xml");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonExistingPlannerBenchmarkConfig() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/nonExistingPlannerBenchmarkConfig.xml");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void testdataPlannerBenchmarkConfigWithClassLoader() {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"divertThroughClassLoader/org/optaplanner/benchmark/api/classloaderTestdataPlannerBenchmarkConfig.xml", (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void testdataPlannerBenchmarkConfigTemplate() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"org/optaplanner/benchmark/api/testdataPlannerBenchmarkConfigTemplate.xml.ftl");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
    }

    @Test
    public void testdataPlannerBenchmarkConfigBenchmarkTemplate() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"org/optaplanner/benchmark/api/testdataPlannerBenchmarkConfigTemplate.xml.ftl");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonExistingPlannerBenchmarkConfigTemplate() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"org/optaplanner/benchmark/api/nonExistingPlannerBenchmarkConfigTemplate.xml.ftl");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void testdataPlannerBenchmarkConfigTemplateWithClassLoader() {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"divertThroughClassLoader/org/optaplanner/benchmark/api/classloaderTestdataPlannerBenchmarkConfigTemplate.xml.ftl", (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }
}

