/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import org.junit.Ignore;
import org.junit.Test;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;

public class SolverBenchmarkConfigTest {
    @Test
    public void validNameWithUnderscoreAndSpace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Valid_name with space_and_underscore");
        config.setSubSingleCount(Integer.valueOf(1));
        config.validate();
    }

    @Test
    @Ignore(value="PLANNER-348 is not in Java 6 (only in Java 7 or higher). See PlannerBenchmarkConfig.VALID_NAME_PATTERN")
    public void validNameWithJapanese() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Valid name (\u6709\u52b9\u540d in Japanese)");
        config.setSubSingleCount(Integer.valueOf(1));
        config.validate();
    }

    @Test(expected=IllegalStateException.class)
    public void invalidNameWithSlash() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("slash/name");
        config.setSubSingleCount(Integer.valueOf(1));
        config.validate();
    }

    @Test(expected=IllegalStateException.class)
    public void invalidNameWithSuffixWhitespace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Suffixed with space ");
        config.setSubSingleCount(Integer.valueOf(1));
        config.validate();
    }

    @Test(expected=IllegalStateException.class)
    public void invalidNameWithPrefixWhitespace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName(" prefixed with space");
        config.setSubSingleCount(Integer.valueOf(1));
        config.validate();
    }

    @Test
    public void validNonZeroSubSingleCount() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("name");
        config.setSubSingleCount(Integer.valueOf(2));
        config.validate();
    }

    public void validNullSubSingleCount() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("name");
        config.setSubSingleCount(null);
        config.validate();
    }

    @Test(expected=IllegalStateException.class)
    public void invalidZeroSubSingleCount() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("name");
        config.setSubSingleCount(Integer.valueOf(0));
        config.validate();
    }
}

