/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.ranking;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.benchmark.impl.ranking.AbstractSolverRankingComparatorTest;
import org.optaplanner.benchmark.impl.ranking.TotalScoreSolverRankingComparator;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;

public class TotalScoreSolverRankingComparatorTest
extends AbstractSolverRankingComparatorTest {
    private BenchmarkReport benchmarkReport;
    private TotalScoreSolverRankingComparator comparator;
    private List<SolverBenchmarkResult> solverBenchmarkResultList;
    private SolverBenchmarkResult a;
    private SolverBenchmarkResult b;
    private List<SingleBenchmarkResult> aSingleBenchmarkResultList;
    private List<SingleBenchmarkResult> bSingleBenchmarkResultList;

    @Before
    public void setUp() {
        this.benchmarkReport = (BenchmarkReport)Mockito.mock(BenchmarkReport.class);
        this.comparator = new TotalScoreSolverRankingComparator();
        this.solverBenchmarkResultList = new ArrayList<SolverBenchmarkResult>();
        this.a = new SolverBenchmarkResult(null);
        this.b = new SolverBenchmarkResult(null);
        this.aSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.bSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
    }

    @Test
    public void normal() {
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -30, -30, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -1000, -50, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -200, -50, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -50, -50, -1000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(this.a, this.b));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(this.b, this.a));
    }

    @Test
    public void totalIsEqual() {
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -1005, -30, -1005);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -200, -30, -1005);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -30, -30, -1005);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -1000, -35, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -200, -35, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -35, -35, -1000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(this.a, this.b));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(this.b, this.a));
    }

    @Test
    public void differentScoreDefinitions() {
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -30, -30, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.addSingleBenchmarkWithHardSoftLongScore(this.bSingleBenchmarkResultList, 0L, -1000L, 0L, -50L, -10L, -1000L);
        this.addSingleBenchmarkWithHardSoftLongScore(this.bSingleBenchmarkResultList, 0L, -200L, 0L, -50L, -10L, -1000L);
        this.addSingleBenchmarkWithHardSoftLongScore(this.bSingleBenchmarkResultList, -7L, -50L, 0L, -50L, -10L, -1000L);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(this.a, this.b));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(this.b, this.a));
    }

    @Test
    public void uninitializedSingleBenchmarks() {
        SingleBenchmarkResult a0 = this.addSingleBenchmark(this.aSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -30, -30, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        SingleBenchmarkResult b0 = this.addSingleBenchmark(this.bSingleBenchmarkResultList, -1000, -30, -1000);
        SingleBenchmarkResult b1 = this.addSingleBenchmark(this.bSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -30, -30, -1000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        Assert.assertEquals((long)0L, (long)this.comparator.compare(this.a, this.b));
        Assert.assertEquals((long)0L, (long)this.comparator.compare(this.b, this.a));
        a0.setAverageUninitializedVariableCount(Integer.valueOf(100));
        b1.setAverageUninitializedVariableCount(Integer.valueOf(100));
        this.a.accumulateResults(this.benchmarkReport);
        this.b.accumulateResults(this.benchmarkReport);
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(this.a, this.b));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(this.b, this.a));
        b0.setAverageUninitializedVariableCount(Integer.valueOf(100));
        this.b.accumulateResults(this.benchmarkReport);
        Assert.assertEquals((long)1L, (long)this.comparator.compare(this.a, this.b));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(this.b, this.a));
        b0.setAverageUninitializedVariableCount(Integer.valueOf(0));
        b1.setAverageUninitializedVariableCount(Integer.valueOf(99));
        this.b.accumulateResults(this.benchmarkReport);
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(this.a, this.b));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(this.b, this.a));
    }
}

