/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;

public class SolverBenchmarkResultTest {
    @Test
    public void testGetAverageScoreWithUninitializedPrefix() throws Exception {
        SolverBenchmarkResult solverBenchmarkResult = (SolverBenchmarkResult)Mockito.spy((Object)new SolverBenchmarkResult(null));
        SingleBenchmarkResult singleBenchmarkResult1 = (SingleBenchmarkResult)Mockito.mock(SingleBenchmarkResult.class);
        SingleBenchmarkResult singleBenchmarkResult2 = (SingleBenchmarkResult)Mockito.mock(SingleBenchmarkResult.class);
        Mockito.when((Object)solverBenchmarkResult.getSingleBenchmarkResultList()).thenReturn(Arrays.asList(singleBenchmarkResult1, singleBenchmarkResult2));
        Mockito.when((Object)solverBenchmarkResult.getAverageScore()).thenReturn((Object)HardSoftScore.valueOf((int)-10, (int)-100));
        Mockito.when((Object)solverBenchmarkResult.getTotalUninitializedVariableCount()).thenReturn((Object)0);
        Mockito.when((Object)solverBenchmarkResult.getFailureCount()).thenReturn((Object)0);
        Assert.assertEquals((Object)"-10hard/-100soft", (Object)solverBenchmarkResult.getAverageScoreWithUninitializedPrefix());
        Mockito.when((Object)solverBenchmarkResult.getTotalUninitializedVariableCount()).thenReturn((Object)2);
        Assert.assertEquals((Object)"1uninitialized/-10hard/-100soft", (Object)solverBenchmarkResult.getAverageScoreWithUninitializedPrefix());
        Mockito.when((Object)solverBenchmarkResult.getTotalUninitializedVariableCount()).thenReturn((Object)3);
        Assert.assertEquals((Object)"2uninitialized/-10hard/-100soft", (Object)solverBenchmarkResult.getAverageScoreWithUninitializedPrefix());
        Mockito.when((Object)solverBenchmarkResult.getTotalUninitializedVariableCount()).thenReturn((Object)1);
        Assert.assertEquals((Object)"1uninitialized/-10hard/-100soft", (Object)solverBenchmarkResult.getAverageScoreWithUninitializedPrefix());
    }

    @Test
    public void testGetAverageScoreWithUninitializedPrefixWithFailure() throws Exception {
        SolverBenchmarkResult solverBenchmarkResult = (SolverBenchmarkResult)Mockito.spy((Object)new SolverBenchmarkResult(null));
        SingleBenchmarkResult singleBenchmarkResult1 = (SingleBenchmarkResult)Mockito.mock(SingleBenchmarkResult.class);
        SingleBenchmarkResult singleBenchmarkResult2 = (SingleBenchmarkResult)Mockito.mock(SingleBenchmarkResult.class);
        Mockito.when((Object)solverBenchmarkResult.getSingleBenchmarkResultList()).thenReturn(Arrays.asList(singleBenchmarkResult1, singleBenchmarkResult2));
        Mockito.when((Object)solverBenchmarkResult.getAverageScore()).thenReturn((Object)HardSoftScore.valueOf((int)-10, (int)-100));
        Mockito.when((Object)solverBenchmarkResult.getTotalUninitializedVariableCount()).thenReturn((Object)2);
        Mockito.when((Object)solverBenchmarkResult.getFailureCount()).thenReturn((Object)1);
        Assert.assertEquals((Object)"2uninitialized/-10hard/-100soft", (Object)solverBenchmarkResult.getAverageScoreWithUninitializedPrefix());
        Mockito.when((Object)solverBenchmarkResult.getFailureCount()).thenReturn((Object)0);
        Assert.assertEquals((Object)"1uninitialized/-10hard/-100soft", (Object)solverBenchmarkResult.getAverageScoreWithUninitializedPrefix());
        Mockito.when((Object)solverBenchmarkResult.getFailureCount()).thenReturn((Object)2);
        Assert.assertEquals(null, (Object)solverBenchmarkResult.getAverageScoreWithUninitializedPrefix());
    }
}

