/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.ranking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.benchmark.impl.ranking.AbstractSolverRankingComparatorTest;
import org.optaplanner.benchmark.impl.ranking.TotalRankSolverRankingWeightFactory;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class TotalRankSolverRankingWeightFactoryTest
extends AbstractSolverRankingComparatorTest {
    private BenchmarkReport benchmarkReport;
    private TotalRankSolverRankingWeightFactory factory;
    private List<SolverBenchmarkResult> solverBenchmarkResultList;
    private SolverBenchmarkResult a;
    private SolverBenchmarkResult b;
    private List<SingleBenchmarkResult> aSingleBenchmarkResultList;
    private List<SingleBenchmarkResult> bSingleBenchmarkResultList;

    @Before
    public void setUp() {
        this.benchmarkReport = (BenchmarkReport)Mockito.mock(BenchmarkReport.class);
        this.factory = new TotalRankSolverRankingWeightFactory();
        this.solverBenchmarkResultList = new ArrayList<SolverBenchmarkResult>();
        this.a = new SolverBenchmarkResult(null);
        this.b = new SolverBenchmarkResult(null);
        this.aSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.bSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
    }

    @Test
    public void normal() {
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -1000, -40, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -300, -40, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -40, -40, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.a);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -2000, -30, -2000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -200, -30, -2000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -30, -30, -2000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.b);
        ArrayList<SingleBenchmarkResult> totalSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>(this.aSingleBenchmarkResultList);
        totalSingleBenchmarkResultList.addAll(this.bSingleBenchmarkResultList);
        this.addProblemBenchmark(totalSingleBenchmarkResultList);
        Comparable aWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.a);
        Comparable bWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.b);
        PlannerAssert.assertCompareToOrder((Comparable[])new Comparable[]{aWeight, bWeight});
    }

    @Test
    public void equalCount() {
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -5000, -90, -5000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -900, -90, -5000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -90, -90, -5000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.a);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -1000, -20, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -200, -20, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -20, -20, -1000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.b);
        SolverBenchmarkResult c = new SolverBenchmarkResult(null);
        ArrayList<SingleBenchmarkResult> cSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.addSingleBenchmark(cSingleBenchmarkResultList, -5000, -10, -5000);
        this.addSingleBenchmark(cSingleBenchmarkResultList, -100, -10, -5000);
        this.addSingleBenchmark(cSingleBenchmarkResultList, -10, -10, -5000);
        c.setSingleBenchmarkResultList(cSingleBenchmarkResultList);
        c.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(c);
        ArrayList<SingleBenchmarkResult> totalSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>(this.aSingleBenchmarkResultList);
        totalSingleBenchmarkResultList.addAll(this.bSingleBenchmarkResultList);
        totalSingleBenchmarkResultList.addAll(cSingleBenchmarkResultList);
        this.addProblemBenchmark(totalSingleBenchmarkResultList);
        Comparable aWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.a);
        Comparable bWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.b);
        Comparable cWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, c);
        PlannerAssert.assertCompareToOrder((Comparable[])new Comparable[]{aWeight, bWeight, cWeight});
    }

    @Test
    public void uninitializedSingleBenchmarks() {
        SingleBenchmarkResult a0 = this.addSingleBenchmark(this.aSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -30, -30, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.a);
        SingleBenchmarkResult b0 = this.addSingleBenchmark(this.bSingleBenchmarkResultList, -1000, -30, -1000);
        SingleBenchmarkResult b1 = this.addSingleBenchmark(this.bSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -30, -30, -1000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.b);
        ArrayList<SingleBenchmarkResult> totalSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>(this.aSingleBenchmarkResultList);
        totalSingleBenchmarkResultList.addAll(this.bSingleBenchmarkResultList);
        this.addProblemBenchmark(totalSingleBenchmarkResultList);
        Comparable aWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.a);
        Comparable bWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.b);
        PlannerAssert.assertCompareToEquals((Comparable[])new Comparable[]{aWeight, bWeight});
        a0.setAverageScore((Score)SimpleScore.valueOf((int)-100, (int)-1000));
        b0.setAverageScore((Score)SimpleScore.valueOf((int)-100, (int)-1000));
        this.a.accumulateResults(this.benchmarkReport);
        this.b.accumulateResults(this.benchmarkReport);
        PlannerAssert.assertCompareToEquals((Comparable[])new Comparable[]{aWeight, bWeight});
        b0.setAverageScore((Score)SimpleScore.valueOfInitialized((int)-1000));
        b1.setAverageScore((Score)SimpleScore.valueOf((int)-100, (int)-400));
        this.b.accumulateResults(this.benchmarkReport);
        PlannerAssert.assertCompareToOrder((Comparable[])new Comparable[]{aWeight, bWeight});
        b1.setAverageScore((Score)SimpleScore.valueOf((int)-101, (int)-400));
        this.b.accumulateResults(this.benchmarkReport);
        PlannerAssert.assertCompareToOrder((Comparable[])new Comparable[]{bWeight, aWeight});
    }

    @Test
    public void differentNumberOfSingleBenchmarks() {
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -400, -30, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.a);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -30, -30, -1000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.b);
        ArrayList<SingleBenchmarkResult> totalSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>(this.aSingleBenchmarkResultList);
        totalSingleBenchmarkResultList.addAll(this.bSingleBenchmarkResultList);
        this.addProblemBenchmark(totalSingleBenchmarkResultList);
        Comparable aWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.a);
        Comparable bWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.b);
        PlannerAssert.assertCompareToOrder((Comparable[])new Comparable[]{aWeight, bWeight});
    }

    @Test
    public void differentScoreTypeOfSingleBenchmarks() {
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -30, -30, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.a);
        this.addSingleBenchmarkWithHardSoftLongScore(this.bSingleBenchmarkResultList, -1000L, 0L, -30L, 0L, -1000L, -1000L);
        this.addSingleBenchmarkWithHardSoftLongScore(this.bSingleBenchmarkResultList, -400L, 0L, -30L, 0L, -1000L, -1000L);
        this.addSingleBenchmarkWithHardSoftLongScore(this.bSingleBenchmarkResultList, -30L, 0L, -30L, 0L, -1000L, -1000L);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.b);
        ArrayList<SingleBenchmarkResult> totalSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>(this.aSingleBenchmarkResultList);
        totalSingleBenchmarkResultList.addAll(this.bSingleBenchmarkResultList);
        this.addProblemBenchmark(totalSingleBenchmarkResultList);
        Comparable aWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.a);
        Comparable bWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.b);
        PlannerAssert.assertCompareToEquals((Comparable[])new Comparable[]{aWeight, bWeight});
    }

    @Test
    public void disjunctPlannnerBenchmarks() {
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -30, -30, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.a);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -2000, -30, -2000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -200, -30, -2000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -30, -30, -2000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.b);
        for (SolverBenchmarkResult solverBenchmarkResult : this.solverBenchmarkResultList) {
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                this.addProblemBenchmark(Arrays.asList(singleBenchmarkResult));
            }
        }
        Comparable aWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.a);
        Comparable bWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.b);
        PlannerAssert.assertCompareToOrder((Comparable[])new Comparable[]{bWeight, aWeight});
    }

    @Test
    public void disjunctEqualPlannerBenchmarks() {
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.aSingleBenchmarkResultList, -30, -30, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.a);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.bSingleBenchmarkResultList, -30, -30, -1000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.b);
        for (SolverBenchmarkResult solverBenchmarkResult : this.solverBenchmarkResultList) {
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                this.addProblemBenchmark(Arrays.asList(singleBenchmarkResult));
            }
        }
        Comparable aWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.a);
        Comparable bWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.b);
        PlannerAssert.assertCompareToEquals((Comparable[])new Comparable[]{aWeight, bWeight});
    }

    @Test
    public void overlappingPlannnerBenchmarks() {
        SingleBenchmarkResult a0 = this.addSingleBenchmark(this.aSingleBenchmarkResultList, -1000, -30, -1000);
        SingleBenchmarkResult a1 = this.addSingleBenchmark(this.aSingleBenchmarkResultList, -400, -30, -1000);
        SingleBenchmarkResult a2 = this.addSingleBenchmark(this.aSingleBenchmarkResultList, -30, -30, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.a);
        SingleBenchmarkResult b0 = this.addSingleBenchmark(this.bSingleBenchmarkResultList, -1000, -30, -1000);
        SingleBenchmarkResult b1 = this.addSingleBenchmark(this.bSingleBenchmarkResultList, -400, -30, -1000);
        SingleBenchmarkResult b2 = this.addSingleBenchmark(this.bSingleBenchmarkResultList, -30, -30, -1000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        this.solverBenchmarkResultList.add(this.b);
        this.addProblemBenchmark(Arrays.asList(a0, b0));
        this.addProblemBenchmark(Arrays.asList(a1, b1));
        this.addProblemBenchmark(Arrays.asList(a2, b2));
        Comparable aWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.a);
        Comparable bWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.b);
        PlannerAssert.assertCompareToEquals((Comparable[])new Comparable[]{aWeight, bWeight});
        this.addProblemBenchmark(Arrays.asList(a1));
        this.addProblemBenchmark(Arrays.asList(a2));
        this.addProblemBenchmark(Arrays.asList(b0));
        this.addProblemBenchmark(Arrays.asList(b2));
        this.addProblemBenchmark(Arrays.asList(a0, b1));
        aWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.a);
        bWeight = this.factory.createRankingWeight(this.solverBenchmarkResultList, this.b);
        PlannerAssert.assertCompareToOrder((Comparable[])new Comparable[]{aWeight, bWeight});
    }
}

