/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.config.blueprint.SolverBenchmarkBluePrintConfig;
import org.optaplanner.benchmark.config.report.BenchmarkReportConfig;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.solver.thread.DefaultSolverThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="plannerBenchmark")
public class PlannerBenchmarkConfig {
    public static final String PARALLEL_BENCHMARK_COUNT_AUTO = "AUTO";
    public static final Pattern VALID_NAME_PATTERN = Pattern.compile("(?U)^[\\w\\d _\\-\\.\\(\\)]+$");
    private static final Logger logger = LoggerFactory.getLogger(PlannerBenchmarkConfig.class);
    private String name = null;
    private File benchmarkDirectory = null;
    private Class<? extends ThreadFactory> threadFactoryClass = null;
    private String parallelBenchmarkCount = null;
    private Long warmUpMillisecondsSpentLimit = null;
    private Long warmUpSecondsSpentLimit = null;
    private Long warmUpMinutesSpentLimit = null;
    private Long warmUpHoursSpentLimit = null;
    private Long warmUpDaysSpentLimit = null;
    @XStreamAlias(value="benchmarkReport")
    private BenchmarkReportConfig benchmarkReportConfig = null;
    @XStreamAlias(value="inheritedSolverBenchmark")
    private SolverBenchmarkConfig inheritedSolverBenchmarkConfig = null;
    @XStreamImplicit(itemFieldName="solverBenchmarkBluePrint")
    private List<SolverBenchmarkBluePrintConfig> solverBenchmarkBluePrintConfigList = null;
    @XStreamImplicit(itemFieldName="solverBenchmark")
    private List<SolverBenchmarkConfig> solverBenchmarkConfigList = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public Class<? extends ThreadFactory> getThreadFactoryClass() {
        return this.threadFactoryClass;
    }

    public void setThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
    }

    public String getParallelBenchmarkCount() {
        return this.parallelBenchmarkCount;
    }

    public void setParallelBenchmarkCount(String parallelBenchmarkCount) {
        this.parallelBenchmarkCount = parallelBenchmarkCount;
    }

    public Long getWarmUpMillisecondsSpentLimit() {
        return this.warmUpMillisecondsSpentLimit;
    }

    public void setWarmUpMillisecondsSpentLimit(Long warmUpMillisecondsSpentLimit) {
        this.warmUpMillisecondsSpentLimit = warmUpMillisecondsSpentLimit;
    }

    public Long getWarmUpSecondsSpentLimit() {
        return this.warmUpSecondsSpentLimit;
    }

    public void setWarmUpSecondsSpentLimit(Long warmUpSecondsSpentLimit) {
        this.warmUpSecondsSpentLimit = warmUpSecondsSpentLimit;
    }

    public Long getWarmUpMinutesSpentLimit() {
        return this.warmUpMinutesSpentLimit;
    }

    public void setWarmUpMinutesSpentLimit(Long warmUpMinutesSpentLimit) {
        this.warmUpMinutesSpentLimit = warmUpMinutesSpentLimit;
    }

    public Long getWarmUpHoursSpentLimit() {
        return this.warmUpHoursSpentLimit;
    }

    public void setWarmUpHoursSpentLimit(Long warmUpHoursSpentLimit) {
        this.warmUpHoursSpentLimit = warmUpHoursSpentLimit;
    }

    public Long getWarmUpDaysSpentLimit() {
        return this.warmUpDaysSpentLimit;
    }

    public void setWarmUpDaysSpentLimit(Long warmUpDaysSpentLimit) {
        this.warmUpDaysSpentLimit = warmUpDaysSpentLimit;
    }

    public BenchmarkReportConfig getBenchmarkReportConfig() {
        return this.benchmarkReportConfig;
    }

    public void setBenchmarkReportConfig(BenchmarkReportConfig benchmarkReportConfig) {
        this.benchmarkReportConfig = benchmarkReportConfig;
    }

    public SolverBenchmarkConfig getInheritedSolverBenchmarkConfig() {
        return this.inheritedSolverBenchmarkConfig;
    }

    public void setInheritedSolverBenchmarkConfig(SolverBenchmarkConfig inheritedSolverBenchmarkConfig) {
        this.inheritedSolverBenchmarkConfig = inheritedSolverBenchmarkConfig;
    }

    public List<SolverBenchmarkBluePrintConfig> getSolverBenchmarkBluePrintConfigList() {
        return this.solverBenchmarkBluePrintConfigList;
    }

    public void setSolverBenchmarkBluePrintConfigList(List<SolverBenchmarkBluePrintConfig> solverBenchmarkBluePrintConfigList) {
        this.solverBenchmarkBluePrintConfigList = solverBenchmarkBluePrintConfigList;
    }

    public List<SolverBenchmarkConfig> getSolverBenchmarkConfigList() {
        return this.solverBenchmarkConfigList;
    }

    public void setSolverBenchmarkConfigList(List<SolverBenchmarkConfig> solverBenchmarkConfigList) {
        this.solverBenchmarkConfigList = solverBenchmarkConfigList;
    }

    public PlannerBenchmark buildPlannerBenchmark() {
        return this.buildPlannerBenchmark(new SolverConfigContext());
    }

    public PlannerBenchmark buildPlannerBenchmark(SolverConfigContext solverConfigContext) {
        this.validate();
        this.generateSolverBenchmarkConfigNames();
        List<SolverBenchmarkConfig> effectiveSolverBenchmarkConfigList = this.buildEffectiveSolverBenchmarkConfigList();
        PlannerBenchmarkResult plannerBenchmarkResult = new PlannerBenchmarkResult();
        plannerBenchmarkResult.setName(this.name);
        plannerBenchmarkResult.setAggregation(false);
        int parallelBenchmarkCount = this.resolveParallelBenchmarkCount();
        plannerBenchmarkResult.setParallelBenchmarkCount(parallelBenchmarkCount);
        plannerBenchmarkResult.setWarmUpTimeMillisSpentLimit((Long)ObjectUtils.defaultIfNull((Object)this.calculateWarmUpTimeMillisSpentLimit(), (Object)30L));
        plannerBenchmarkResult.setUnifiedProblemBenchmarkResultList(new ArrayList<ProblemBenchmarkResult>());
        plannerBenchmarkResult.setSolverBenchmarkResultList(new ArrayList<SolverBenchmarkResult>(effectiveSolverBenchmarkConfigList.size()));
        for (SolverBenchmarkConfig solverBenchmarkConfig : effectiveSolverBenchmarkConfigList) {
            solverBenchmarkConfig.buildSolverBenchmark(solverConfigContext, plannerBenchmarkResult);
        }
        BenchmarkReportConfig benchmarkReportConfig_ = this.benchmarkReportConfig == null ? new BenchmarkReportConfig() : this.benchmarkReportConfig;
        BenchmarkReport benchmarkReport = benchmarkReportConfig_.buildBenchmarkReport(plannerBenchmarkResult);
        return new DefaultPlannerBenchmark(plannerBenchmarkResult, solverConfigContext, this.benchmarkDirectory, this.buildExecutorService(parallelBenchmarkCount), this.buildExecutorService(parallelBenchmarkCount), benchmarkReport);
    }

    private ExecutorService buildExecutorService(int parallelBenchmarkCount) {
        Object threadFactory = this.threadFactoryClass != null ? (ThreadFactory)ConfigUtils.newInstance((Object)this, (String)"threadFactoryClass", this.threadFactoryClass) : new DefaultSolverThreadFactory("BenchmarkThread");
        return Executors.newFixedThreadPool(parallelBenchmarkCount, (ThreadFactory)threadFactory);
    }

    protected void validate() {
        if (this.name != null) {
            if (!VALID_NAME_PATTERN.matcher(this.name).matches()) {
                throw new IllegalStateException("The plannerBenchmark name (" + this.name + ") is invalid because it does not follow the nameRegex (" + VALID_NAME_PATTERN.pattern() + ") which might cause an illegal filename.");
            }
            if (!this.name.trim().equals(this.name)) {
                throw new IllegalStateException("The plannerBenchmark name (" + this.name + ") is invalid because it starts or ends with whitespace.");
            }
        }
        if (ConfigUtils.isEmptyCollection(this.solverBenchmarkBluePrintConfigList) && ConfigUtils.isEmptyCollection(this.solverBenchmarkConfigList)) {
            throw new IllegalArgumentException("Configure at least 1 <solverBenchmark> (or 1 <solverBenchmarkBluePrint>) in the <plannerBenchmark> configuration.");
        }
    }

    protected void generateSolverBenchmarkConfigNames() {
        if (this.solverBenchmarkConfigList != null) {
            HashSet<String> nameSet = new HashSet<String>(this.solverBenchmarkConfigList.size());
            LinkedHashSet<SolverBenchmarkConfig> noNameBenchmarkConfigSet = new LinkedHashSet<SolverBenchmarkConfig>(this.solverBenchmarkConfigList.size());
            for (SolverBenchmarkConfig solverBenchmarkConfig : this.solverBenchmarkConfigList) {
                if (solverBenchmarkConfig.getName() != null) {
                    boolean unique = nameSet.add(solverBenchmarkConfig.getName());
                    if (unique) continue;
                    throw new IllegalStateException("The benchmark name (" + solverBenchmarkConfig.getName() + ") is used in more than 1 benchmark.");
                }
                noNameBenchmarkConfigSet.add(solverBenchmarkConfig);
            }
            int generatedNameIndex = 0;
            for (SolverBenchmarkConfig solverBenchmarkConfig : noNameBenchmarkConfigSet) {
                String generatedName = "Config_" + generatedNameIndex;
                while (nameSet.contains(generatedName)) {
                    generatedName = "Config_" + ++generatedNameIndex;
                }
                solverBenchmarkConfig.setName(generatedName);
                ++generatedNameIndex;
            }
        }
    }

    protected List<SolverBenchmarkConfig> buildEffectiveSolverBenchmarkConfigList() {
        ArrayList<SolverBenchmarkConfig> effectiveSolverBenchmarkConfigList = new ArrayList<SolverBenchmarkConfig>(0);
        if (this.solverBenchmarkConfigList != null) {
            effectiveSolverBenchmarkConfigList.addAll(this.solverBenchmarkConfigList);
        }
        if (this.solverBenchmarkBluePrintConfigList != null) {
            for (SolverBenchmarkBluePrintConfig solverBenchmarkBluePrintConfig : this.solverBenchmarkBluePrintConfigList) {
                effectiveSolverBenchmarkConfigList.addAll(solverBenchmarkBluePrintConfig.buildSolverBenchmarkConfigList());
            }
        }
        if (this.inheritedSolverBenchmarkConfig != null) {
            for (SolverBenchmarkConfig solverBenchmarkConfig : effectiveSolverBenchmarkConfigList) {
                solverBenchmarkConfig.inherit(this.inheritedSolverBenchmarkConfig);
            }
        }
        return effectiveSolverBenchmarkConfigList;
    }

    protected int resolveParallelBenchmarkCount() {
        int availableProcessorCount = Runtime.getRuntime().availableProcessors();
        int resolvedParallelBenchmarkCount = this.parallelBenchmarkCount == null ? 1 : (this.parallelBenchmarkCount.equals(PARALLEL_BENCHMARK_COUNT_AUTO) ? this.resolveParallelBenchmarkCountAutomatically(availableProcessorCount) : ConfigUtils.resolveThreadPoolSizeScript((String)"parallelBenchmarkCount", (String)this.parallelBenchmarkCount, (String[])new String[]{PARALLEL_BENCHMARK_COUNT_AUTO}));
        if (resolvedParallelBenchmarkCount < 1) {
            throw new IllegalArgumentException("The parallelBenchmarkCount (" + this.parallelBenchmarkCount + ") resulted in a resolvedParallelBenchmarkCount (" + resolvedParallelBenchmarkCount + ") that is lower than 1.");
        }
        if (resolvedParallelBenchmarkCount > availableProcessorCount) {
            logger.warn("Because the resolvedParallelBenchmarkCount (" + resolvedParallelBenchmarkCount + ") is higher than the availableProcessorCount (" + availableProcessorCount + "), it is reduced to availableProcessorCount.");
            resolvedParallelBenchmarkCount = availableProcessorCount;
        }
        return resolvedParallelBenchmarkCount;
    }

    protected int resolveParallelBenchmarkCountAutomatically(int availableProcessorCount) {
        if (availableProcessorCount <= 2) {
            return 1;
        }
        if (availableProcessorCount <= 4) {
            return 2;
        }
        return availableProcessorCount / 2 + 1;
    }

    protected Long calculateWarmUpTimeMillisSpentLimit() {
        if (this.warmUpMillisecondsSpentLimit == null && this.warmUpSecondsSpentLimit == null && this.warmUpMinutesSpentLimit == null && this.warmUpHoursSpentLimit == null && this.warmUpDaysSpentLimit == null) {
            return null;
        }
        long warmUpTimeMillisSpentLimit = 0L;
        if (this.warmUpMillisecondsSpentLimit != null) {
            if (this.warmUpMillisecondsSpentLimit < 0L) {
                throw new IllegalArgumentException("The warmUpMillisecondsSpentLimit (" + this.warmUpMillisecondsSpentLimit + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.warmUpMillisecondsSpentLimit.longValue();
        }
        if (this.warmUpSecondsSpentLimit != null) {
            if (this.warmUpSecondsSpentLimit < 0L) {
                throw new IllegalArgumentException("The warmUpSecondsSpentLimit (" + this.warmUpSecondsSpentLimit + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.warmUpSecondsSpentLimit * 1000L;
        }
        if (this.warmUpMinutesSpentLimit != null) {
            if (this.warmUpMinutesSpentLimit < 0L) {
                throw new IllegalArgumentException("The warmUpMinutesSpentLimit (" + this.warmUpMinutesSpentLimit + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.warmUpMinutesSpentLimit * 60000L;
        }
        if (this.warmUpHoursSpentLimit != null) {
            if (this.warmUpHoursSpentLimit < 0L) {
                throw new IllegalArgumentException("The warmUpHoursSpentLimit (" + this.warmUpHoursSpentLimit + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.warmUpHoursSpentLimit * 3600000L;
        }
        if (this.warmUpDaysSpentLimit != null) {
            if (this.warmUpDaysSpentLimit < 0L) {
                throw new IllegalArgumentException("The warmUpDaysSpentLimit (" + this.warmUpDaysSpentLimit + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.warmUpDaysSpentLimit * 86400000L;
        }
        return warmUpTimeMillisSpentLimit;
    }
}

