/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.api;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.core.api.solver.DivertingClassLoader;
import org.optaplanner.core.config.phase.custom.CustomPhaseConfig;
import org.optaplanner.core.impl.phase.custom.NoChangeCustomPhaseCommand;

public class PlannerBenchmarkFactoryTest {
    @BeforeClass
    public static void setup() throws IOException {
        File benchmarkTestDir = new File("target/benchmarkTest/");
        benchmarkTestDir.mkdirs();
        new File(benchmarkTestDir, "input.xml").createNewFile();
        new File(benchmarkTestDir, "output/").mkdir();
    }

    @Test
    public void benchmarkConfig() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/testdataPlannerBenchmarkConfig.xml");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonExistingBenchmarkConfig() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/nonExistingPlannerBenchmarkConfig.xml");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void uninitializedBenchmarkResult() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/testdataPlannerBenchmarkConfig.xml");
        SolverBenchmarkConfig solverBenchmarkConfig = (SolverBenchmarkConfig)plannerBenchmarkFactory.getPlannerBenchmarkConfig().getSolverBenchmarkConfigList().get(0);
        CustomPhaseConfig phaseConfig = new CustomPhaseConfig();
        phaseConfig.setCustomPhaseCommandClassList(Collections.singletonList(NoChangeCustomPhaseCommand.class));
        solverBenchmarkConfig.getSolverConfig().setPhaseConfigList(Collections.singletonList(phaseConfig));
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void subSingleBenchmarkConfig() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/testdataPlannerBenchmarkConfig.xml");
        SolverBenchmarkConfig solverBenchmarkConfig = (SolverBenchmarkConfig)plannerBenchmarkFactory.getPlannerBenchmarkConfig().getSolverBenchmarkConfigList().get(0);
        solverBenchmarkConfig.setSubSingleCount(Integer.valueOf(3));
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void benchmarkConfigWithClassLoader() {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"divertThroughClassLoader/org/optaplanner/benchmark/api/classloaderTestdataPlannerBenchmarkConfig.xml", (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void template() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"org/optaplanner/benchmark/api/testdataPlannerBenchmarkConfigTemplate.xml.ftl");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonExistingTemplate() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"org/optaplanner/benchmark/api/nonExistingPlannerBenchmarkConfigTemplate.xml.ftl");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void templateWithClassLoader() {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"divertThroughClassLoader/org/optaplanner/benchmark/api/classloaderTestdataPlannerBenchmarkConfigTemplate.xml.ftl", (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }
}

