/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.loader;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.benchmark.impl.loader.ProblemProvider;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

@XStreamAlias(value="fileProblemProvider")
public class FileProblemProvider<Solution_>
implements ProblemProvider<Solution_> {
    @XStreamOmitField
    private final SolutionFileIO<Solution_> solutionFileIO;
    private final File problemFile;

    public FileProblemProvider(SolutionFileIO<Solution_> solutionFileIO, File problemFile) {
        this.solutionFileIO = solutionFileIO;
        this.problemFile = problemFile;
    }

    public SolutionFileIO<Solution_> getSolutionFileIO() {
        return this.solutionFileIO;
    }

    public File getProblemFile() {
        return this.problemFile;
    }

    @Override
    public String getProblemName() {
        return FilenameUtils.getBaseName((String)this.problemFile.getName());
    }

    @Override
    public Solution_ readProblem() {
        return (Solution_)this.solutionFileIO.read(this.problemFile);
    }

    @Override
    public void writeSolution(Solution_ solution, SubSingleBenchmarkResult subSingleBenchmarkResult) {
        String filename = subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult().getName() + "." + this.solutionFileIO.getOutputFileExtension();
        File solutionFile = new File(subSingleBenchmarkResult.getResultDirectory(), filename);
        this.solutionFileIO.write(solution, solutionFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FileProblemProvider) {
            FileProblemProvider other = (FileProblemProvider)o;
            return this.problemFile.equals(other.problemFile);
        }
        return false;
    }

    public int hashCode() {
        return this.problemFile.hashCode();
    }

    public String toString() {
        return this.problemFile.toString();
    }
}

