/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.impl.SolverBenchmarkFactory;

public class SolverBenchmarkFactoryTest {
    @Test
    public void validNameWithUnderscoreAndSpace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Valid_name with space_and_underscore");
        config.setSubSingleCount(Integer.valueOf(1));
        this.validateConfig(config);
    }

    @Test
    public void validNameWithJapanese() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Valid name (\u6709\u52b9\u540d in Japanese)");
        config.setSubSingleCount(Integer.valueOf(1));
        this.validateConfig(config);
    }

    @Test
    public void invalidNameWithSlash() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("slash/name");
        config.setSubSingleCount(Integer.valueOf(1));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.validateConfig(config));
    }

    @Test
    public void invalidNameWithSuffixWhitespace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Suffixed with space ");
        config.setSubSingleCount(Integer.valueOf(1));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.validateConfig(config));
    }

    @Test
    public void invalidNameWithPrefixWhitespace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName(" prefixed with space");
        config.setSubSingleCount(Integer.valueOf(1));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.validateConfig(config));
    }

    @Test
    public void validNonZeroSubSingleCount() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("name");
        config.setSubSingleCount(Integer.valueOf(2));
        this.validateConfig(config);
    }

    @Test
    public void validNullSubSingleCount() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("name");
        config.setSubSingleCount(null);
        this.validateConfig(config);
    }

    @Test
    public void invalidZeroSubSingleCount() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("name");
        config.setSubSingleCount(Integer.valueOf(0));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.validateConfig(config));
    }

    private void validateConfig(SolverBenchmarkConfig config) {
        SolverBenchmarkFactory solverBenchmarkFactory = new SolverBenchmarkFactory(config);
        solverBenchmarkFactory.validate();
    }
}

