/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.memoryuse;

import io.micrometer.core.instrument.Tags;
import java.util.List;
import java.util.function.Consumer;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemBasedSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticRegistry;
import org.optaplanner.benchmark.impl.statistic.memoryuse.MemoryUseMeasurement;
import org.optaplanner.benchmark.impl.statistic.memoryuse.MemoryUseStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.solver.monitoring.SolverMetric;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public class MemoryUseSubSingleStatistic<Solution_>
extends ProblemBasedSubSingleStatistic<Solution_, MemoryUseStatisticPoint> {
    private final long timeMillisThresholdInterval;

    public MemoryUseSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        this(subSingleBenchmarkResult, 1000L);
    }

    public MemoryUseSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult, long timeMillisThresholdInterval) {
        super(subSingleBenchmarkResult, ProblemStatisticType.MEMORY_USE);
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
    }

    @Override
    public void open(StatisticRegistry<Solution_> registry, Tags runTag, Solver<Solution_> solver) {
        registry.addListener(SolverMetric.MEMORY_USE, new MemoryUseSubSingleStatisticListener(registry, runTag));
    }

    @Override
    protected String getCsvHeader() {
        return MemoryUseStatisticPoint.buildCsvLine("timeMillisSpent", "usedMemory", "maxMemory");
    }

    @Override
    protected MemoryUseStatisticPoint createPointFromCsvLine(ScoreDefinition<?> scoreDefinition, List<String> csvLine) {
        return new MemoryUseStatisticPoint(Long.parseLong(csvLine.get(0)), new MemoryUseMeasurement(Long.parseLong(csvLine.get(1)), Long.parseLong(csvLine.get(2))));
    }

    private class MemoryUseSubSingleStatisticListener
    implements Consumer<Long> {
        private long nextTimeMillisThreshold;
        private final StatisticRegistry<?> registry;
        private final Tags tags;

        public MemoryUseSubSingleStatisticListener(StatisticRegistry<?> registry, Tags tags) {
            this.nextTimeMillisThreshold = MemoryUseSubSingleStatistic.this.timeMillisThresholdInterval;
            this.registry = registry;
            this.tags = tags;
        }

        @Override
        public void accept(Long timeMillisSpent) {
            if (timeMillisSpent >= this.nextTimeMillisThreshold) {
                this.registry.getGaugeValue(SolverMetric.MEMORY_USE, this.tags, memoryUse -> MemoryUseSubSingleStatistic.this.pointList.add(new MemoryUseStatisticPoint(timeMillisSpent, new MemoryUseMeasurement(memoryUse.longValue(), (long)this.registry.find("jvm.memory.max").tags((Iterable)this.tags).gauge().value()))));
                this.nextTimeMillisThreshold += MemoryUseSubSingleStatistic.this.timeMillisThresholdInterval;
                if (this.nextTimeMillisThreshold < timeMillisSpent) {
                    this.nextTimeMillisThreshold = timeMillisSpent;
                }
            }
        }
    }
}

