/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.scorecalculationspeed;

import io.micrometer.core.instrument.Tags;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemBasedSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticRegistry;
import org.optaplanner.benchmark.impl.statistic.scorecalculationspeed.ScoreCalculationSpeedStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.solver.monitoring.SolverMetric;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public class ScoreCalculationSpeedSubSingleStatistic<Solution_>
extends ProblemBasedSubSingleStatistic<Solution_, ScoreCalculationSpeedStatisticPoint> {
    private final long timeMillisThresholdInterval;

    public ScoreCalculationSpeedSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        this(subSingleBenchmarkResult, 1000L);
    }

    public ScoreCalculationSpeedSubSingleStatistic(SubSingleBenchmarkResult benchmarkResult, long timeMillisThresholdInterval) {
        super(benchmarkResult, ProblemStatisticType.SCORE_CALCULATION_SPEED);
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
    }

    @Override
    public void open(final StatisticRegistry<Solution_> registry, final Tags runTag, Solver<Solution_> solver) {
        registry.addListener(SolverMetric.SCORE_CALCULATION_COUNT, new Consumer<Long>(){
            long nextTimeMillisThreshold;
            long lastTimeMillisSpent;
            final AtomicLong lastScoreCalculationCount;
            {
                this.nextTimeMillisThreshold = ScoreCalculationSpeedSubSingleStatistic.this.timeMillisThresholdInterval;
                this.lastTimeMillisSpent = 0L;
                this.lastScoreCalculationCount = new AtomicLong(0L);
            }

            @Override
            public void accept(Long timeMillisSpent) {
                if (timeMillisSpent >= this.nextTimeMillisThreshold) {
                    registry.getGaugeValue(SolverMetric.SCORE_CALCULATION_COUNT, runTag, scoreCalculationCountNumber -> {
                        long scoreCalculationCount = scoreCalculationCountNumber.longValue();
                        long calculationCountInterval = scoreCalculationCount - this.lastScoreCalculationCount.get();
                        long timeMillisSpentInterval = timeMillisSpent - this.lastTimeMillisSpent;
                        if (timeMillisSpentInterval == 0L) {
                            timeMillisSpentInterval = 1L;
                        }
                        long scoreCalculationSpeed = calculationCountInterval * 1000L / timeMillisSpentInterval;
                        ScoreCalculationSpeedSubSingleStatistic.this.pointList.add(new ScoreCalculationSpeedStatisticPoint(timeMillisSpent, scoreCalculationSpeed));
                        this.lastScoreCalculationCount.set(scoreCalculationCount);
                    });
                    this.lastTimeMillisSpent = timeMillisSpent;
                    this.nextTimeMillisThreshold += ScoreCalculationSpeedSubSingleStatistic.this.timeMillisThresholdInterval;
                    if (this.nextTimeMillisThreshold < timeMillisSpent) {
                        this.nextTimeMillisThreshold = timeMillisSpent;
                    }
                }
            }
        });
    }

    @Override
    protected String getCsvHeader() {
        return ScoreCalculationSpeedStatisticPoint.buildCsvLine("timeMillisSpent", "scoreCalculationSpeed");
    }

    @Override
    protected ScoreCalculationSpeedStatisticPoint createPointFromCsvLine(ScoreDefinition<?> scoreDefinition, List<String> csvLine) {
        return new ScoreCalculationSpeedStatisticPoint(Long.parseLong(csvLine.get(0)), Long.parseLong(csvLine.get(1)));
    }
}

