/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.benchmark.config.ProblemBenchmarksConfig;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;

class ProblemBenchmarksConfigTest {
    ProblemBenchmarksConfigTest() {
    }

    @Test
    void testDetermineProblemStatisticTypeList() {
        ProblemBenchmarksConfig problemBenchmarksConfig = new ProblemBenchmarksConfig();
        Assertions.assertThat((List)problemBenchmarksConfig.determineProblemStatisticTypeList()).isEqualTo((Object)ProblemStatisticType.defaultList());
        problemBenchmarksConfig.setProblemStatisticTypeList(Collections.emptyList());
        Assertions.assertThat((List)problemBenchmarksConfig.determineProblemStatisticTypeList()).isEqualTo((Object)ProblemStatisticType.defaultList());
        Assertions.assertThat((List)ProblemStatisticType.defaultList()).isNotEqualTo(List.of(ProblemStatisticType.MEMORY_USE));
        problemBenchmarksConfig.setProblemStatisticTypeList(List.of(ProblemStatisticType.MEMORY_USE));
        Assertions.assertThat((List)problemBenchmarksConfig.determineProblemStatisticTypeList()).containsExactly((Object[])new ProblemStatisticType[]{ProblemStatisticType.MEMORY_USE});
        problemBenchmarksConfig.setProblemStatisticEnabled(Boolean.valueOf(true));
        Assertions.assertThat((List)problemBenchmarksConfig.determineProblemStatisticTypeList()).containsExactly((Object[])new ProblemStatisticType[]{ProblemStatisticType.MEMORY_USE});
        problemBenchmarksConfig.setProblemStatisticEnabled(Boolean.valueOf(false));
        Assertions.assertThat((List)problemBenchmarksConfig.determineProblemStatisticTypeList()).isEmpty();
    }

    @Test
    void testDetermineSingleStatisticTypeList() {
        ProblemBenchmarksConfig problemBenchmarksConfig = new ProblemBenchmarksConfig();
        Assertions.assertThat((List)problemBenchmarksConfig.determineSingleStatisticTypeList()).isEmpty();
        problemBenchmarksConfig.setSingleStatisticTypeList(Collections.emptyList());
        Assertions.assertThat((List)problemBenchmarksConfig.determineSingleStatisticTypeList()).isEmpty();
        problemBenchmarksConfig.setSingleStatisticTypeList(List.of(SingleStatisticType.CONSTRAINT_MATCH_TOTAL_STEP_SCORE));
        Assertions.assertThat((List)problemBenchmarksConfig.determineSingleStatisticTypeList()).containsExactly((Object[])new SingleStatisticType[]{SingleStatisticType.CONSTRAINT_MATCH_TOTAL_STEP_SCORE});
    }
}

