/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.optaplanner.benchmark.impl.measurement.ScoreDifferencePercentage;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.StatisticUtils;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.io.jaxb.GenericJaxbIO;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public class SolverBenchmarkResult {
    @XmlTransient
    private PlannerBenchmarkResult plannerBenchmarkResult;
    private String name = null;
    private Integer subSingleCount = null;
    @XmlElement(namespace="https://www.optaplanner.org/xsd/solver")
    private SolverConfig solverConfig = null;
    @XmlTransient
    private ScoreDefinition scoreDefinition = null;
    @XmlElement(name="singleBenchmarkResult")
    private List<SingleBenchmarkResult> singleBenchmarkResultList = null;
    private Integer failureCount = null;
    private Integer uninitializedSolutionCount = null;
    private Integer infeasibleScoreCount = null;
    private Score totalScore = null;
    private Score averageScore = null;
    private double[] standardDeviationDoubles = null;
    private Score totalWinningScoreDifference = null;
    private ScoreDifferencePercentage averageWorstScoreDifferencePercentage = null;
    private Long averageScoreCalculationSpeed = null;
    private Long averageTimeMillisSpent = null;
    private Double averageWorstScoreCalculationSpeedDifferencePercentage = null;
    private Integer ranking = null;

    private SolverBenchmarkResult() {
    }

    public SolverBenchmarkResult(PlannerBenchmarkResult plannerBenchmarkResult) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
    }

    public PlannerBenchmarkResult getPlannerBenchmarkResult() {
        return this.plannerBenchmarkResult;
    }

    public void setPlannerBenchmarkResult(PlannerBenchmarkResult plannerBenchmarkResult) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getSubSingleCount() {
        return this.subSingleCount;
    }

    public void setSubSingleCount(Integer subSingleCount) {
        this.subSingleCount = subSingleCount;
    }

    public SolverConfig getSolverConfig() {
        return this.solverConfig;
    }

    public void setSolverConfig(SolverConfig solverConfig) {
        this.solverConfig = solverConfig;
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDefinition;
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    public List<SingleBenchmarkResult> getSingleBenchmarkResultList() {
        return this.singleBenchmarkResultList;
    }

    public void setSingleBenchmarkResultList(List<SingleBenchmarkResult> singleBenchmarkResultList) {
        this.singleBenchmarkResultList = singleBenchmarkResultList;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public Integer getUninitializedSolutionCount() {
        return this.uninitializedSolutionCount;
    }

    public Integer getInfeasibleScoreCount() {
        return this.infeasibleScoreCount;
    }

    public Score getTotalScore() {
        return this.totalScore;
    }

    public Score getAverageScore() {
        return this.averageScore;
    }

    public Score getTotalWinningScoreDifference() {
        return this.totalWinningScoreDifference;
    }

    public ScoreDifferencePercentage getAverageWorstScoreDifferencePercentage() {
        return this.averageWorstScoreDifferencePercentage;
    }

    public Long getAverageScoreCalculationSpeed() {
        return this.averageScoreCalculationSpeed;
    }

    public Long getAverageTimeMillisSpent() {
        return this.averageTimeMillisSpent;
    }

    public Double getAverageWorstScoreCalculationSpeedDifferencePercentage() {
        return this.averageWorstScoreCalculationSpeedDifferencePercentage;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public void setRanking(Integer ranking) {
        this.ranking = ranking;
    }

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.name);
    }

    public String getNameWithFavoriteSuffix() {
        if (this.isFavorite()) {
            return this.name + " (favorite)";
        }
        return this.name;
    }

    public int getSuccessCount() {
        return this.getSingleBenchmarkResultList().size() - this.getFailureCount();
    }

    public boolean hasAnySuccess() {
        return this.getSuccessCount() > 0;
    }

    public boolean hasAnyFailure() {
        return this.failureCount > 0;
    }

    public boolean hasAnyUninitializedSolution() {
        return this.uninitializedSolutionCount > 0;
    }

    public boolean hasAnyInfeasibleScore() {
        return this.infeasibleScoreCount > 0;
    }

    public boolean isFavorite() {
        return this.ranking != null && this.ranking == 0;
    }

    public Score getAverageWinningScoreDifference() {
        if (this.totalWinningScoreDifference == null) {
            return null;
        }
        return this.totalWinningScoreDifference.divide((double)this.getSuccessCount());
    }

    public List<Score> getScoreList() {
        ArrayList<Score> scoreList = new ArrayList<Score>(this.singleBenchmarkResultList.size());
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            scoreList.add(singleBenchmarkResult.getAverageScore());
        }
        return scoreList;
    }

    public SingleBenchmarkResult findSingleBenchmark(ProblemBenchmarkResult problemBenchmarkResult) {
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            if (!problemBenchmarkResult.equals(singleBenchmarkResult.getProblemBenchmarkResult())) continue;
            return singleBenchmarkResult;
        }
        return null;
    }

    public String getSolverConfigAsString() {
        GenericJaxbIO xmlIO = new GenericJaxbIO(SolverConfig.class);
        StringWriter stringWriter = new StringWriter();
        xmlIO.write((Object)this.solverConfig, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.solverConfig.determineEnvironmentMode();
    }

    public String getStandardDeviationString() {
        return StatisticUtils.getStandardDeviationString(this.standardDeviationDoubles);
    }

    public void accumulateResults(BenchmarkReport benchmarkReport) {
        this.determineTotalsAndAverages();
        this.standardDeviationDoubles = StatisticUtils.determineStandardDeviationDoubles(this.singleBenchmarkResultList, this.averageScore, this.getSuccessCount());
    }

    protected void determineTotalsAndAverages() {
        this.failureCount = 0;
        boolean firstNonFailure = true;
        this.totalScore = null;
        this.totalWinningScoreDifference = null;
        ScoreDifferencePercentage totalWorstScoreDifferencePercentage = null;
        long totalScoreCalculationSpeed = 0L;
        long totalTimeMillisSpent = 0L;
        double totalWorstScoreCalculationSpeedDifferencePercentage = 0.0;
        this.uninitializedSolutionCount = 0;
        this.infeasibleScoreCount = 0;
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            Integer n;
            if (singleBenchmarkResult.hasAnyFailure()) {
                n = this.failureCount;
                this.failureCount = this.failureCount + 1;
                continue;
            }
            if (!singleBenchmarkResult.isInitialized()) {
                n = this.uninitializedSolutionCount;
                this.uninitializedSolutionCount = this.uninitializedSolutionCount + 1;
            } else if (!singleBenchmarkResult.isScoreFeasible()) {
                n = this.infeasibleScoreCount;
                this.infeasibleScoreCount = this.infeasibleScoreCount + 1;
            }
            if (firstNonFailure) {
                this.totalScore = singleBenchmarkResult.getAverageScore();
                this.totalWinningScoreDifference = singleBenchmarkResult.getWinningScoreDifference();
                totalWorstScoreDifferencePercentage = singleBenchmarkResult.getWorstScoreDifferencePercentage();
                totalScoreCalculationSpeed = singleBenchmarkResult.getScoreCalculationSpeed();
                totalTimeMillisSpent = singleBenchmarkResult.getTimeMillisSpent();
                totalWorstScoreCalculationSpeedDifferencePercentage = singleBenchmarkResult.getWorstScoreCalculationSpeedDifferencePercentage();
                firstNonFailure = false;
                continue;
            }
            this.totalScore = this.totalScore.add(singleBenchmarkResult.getAverageScore());
            this.totalWinningScoreDifference = this.totalWinningScoreDifference.add(singleBenchmarkResult.getWinningScoreDifference());
            totalWorstScoreDifferencePercentage = totalWorstScoreDifferencePercentage.add(singleBenchmarkResult.getWorstScoreDifferencePercentage());
            totalScoreCalculationSpeed += singleBenchmarkResult.getScoreCalculationSpeed().longValue();
            totalTimeMillisSpent += singleBenchmarkResult.getTimeMillisSpent();
            totalWorstScoreCalculationSpeedDifferencePercentage += singleBenchmarkResult.getWorstScoreCalculationSpeedDifferencePercentage().doubleValue();
        }
        if (!firstNonFailure) {
            int successCount = this.getSuccessCount();
            this.averageScore = this.totalScore.divide((double)successCount);
            this.averageWorstScoreDifferencePercentage = totalWorstScoreDifferencePercentage.divide(successCount);
            this.averageScoreCalculationSpeed = totalScoreCalculationSpeed / (long)successCount;
            this.averageTimeMillisSpent = totalTimeMillisSpent / (long)successCount;
            this.averageWorstScoreCalculationSpeedDifferencePercentage = totalWorstScoreCalculationSpeedDifferencePercentage / (double)successCount;
        }
    }

    protected static Map<SolverBenchmarkResult, SolverBenchmarkResult> createMergeMap(PlannerBenchmarkResult newPlannerBenchmarkResult, List<SingleBenchmarkResult> singleBenchmarkResultList) {
        SolverBenchmarkResult newResult;
        SolverBenchmarkResult oldResult;
        IdentityHashMap<SolverBenchmarkResult, SolverBenchmarkResult> mergeMap = new IdentityHashMap<SolverBenchmarkResult, SolverBenchmarkResult>();
        HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>();
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            oldResult = singleBenchmarkResult.getSolverBenchmarkResult();
            if (mergeMap.containsKey(oldResult)) continue;
            newResult = new SolverBenchmarkResult(newPlannerBenchmarkResult);
            Integer nameCount = (Integer)nameCountMap.get(oldResult.name);
            if (nameCount == null) {
                nameCount = 1;
            } else {
                Integer n = nameCount;
                nameCount = nameCount + 1;
            }
            nameCountMap.put(oldResult.name, nameCount);
            newResult.subSingleCount = oldResult.subSingleCount;
            newResult.solverConfig = oldResult.solverConfig;
            newResult.scoreDefinition = oldResult.scoreDefinition;
            newResult.singleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>(oldResult.singleBenchmarkResultList.size());
            mergeMap.put(oldResult, newResult);
            newPlannerBenchmarkResult.getSolverBenchmarkResultList().add(newResult);
        }
        for (Map.Entry entry : mergeMap.entrySet()) {
            oldResult = (SolverBenchmarkResult)entry.getKey();
            newResult = (SolverBenchmarkResult)entry.getValue();
            if ((Integer)nameCountMap.get(oldResult.name) > 1) {
                newResult.name = oldResult.name + " (" + oldResult.getPlannerBenchmarkResult().getName() + ")";
                continue;
            }
            newResult.name = oldResult.name;
        }
        return mergeMap;
    }

    public String toString() {
        return this.getName();
    }
}

