/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmarkFactory;

class DefaultPlannerBenchmarkFactoryTest {
    DefaultPlannerBenchmarkFactoryTest() {
    }

    @Test
    void validNameWithUnderscoreAndSpace() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("Valid_name with space_and_underscore");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        new DefaultPlannerBenchmarkFactory(config).validate();
    }

    @Test
    void validNameWithJapanese() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("Valid name (\u6709\u52b9\u540d in Japanese)");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        DefaultPlannerBenchmarkFactory benchmarkFactory = new DefaultPlannerBenchmarkFactory(config);
        benchmarkFactory.validate();
    }

    @Test
    void invalidNameWithSlash() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("slash/name");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        DefaultPlannerBenchmarkFactory benchmarkFactory = new DefaultPlannerBenchmarkFactory(config);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((DefaultPlannerBenchmarkFactory)benchmarkFactory).validate());
    }

    @Test
    void invalidNameWithSuffixWhitespace() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("Suffixed with space ");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        DefaultPlannerBenchmarkFactory benchmarkFactory = new DefaultPlannerBenchmarkFactory(config);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((DefaultPlannerBenchmarkFactory)benchmarkFactory).validate());
    }

    @Test
    void invalidNameWithPrefixWhitespace() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName(" prefixed with space");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        DefaultPlannerBenchmarkFactory benchmarkFactory = new DefaultPlannerBenchmarkFactory(config);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((DefaultPlannerBenchmarkFactory)benchmarkFactory).validate());
    }

    @Test
    void noSolverConfigs() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setSolverBenchmarkConfigList(null);
        config.setSolverBenchmarkBluePrintConfigList(null);
        DefaultPlannerBenchmarkFactory benchmarkFactory = new DefaultPlannerBenchmarkFactory(config);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> ((DefaultPlannerBenchmarkFactory)benchmarkFactory).validate());
    }

    @Test
    void nonUniqueSolverConfigName() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        String sbcName = "x";
        SolverBenchmarkConfig sbc1 = new SolverBenchmarkConfig();
        sbc1.setName("x");
        SolverBenchmarkConfig sbc2 = new SolverBenchmarkConfig();
        sbc2.setName("x");
        config.setSolverBenchmarkConfigList(Arrays.asList(sbc1, sbc2));
        DefaultPlannerBenchmarkFactory benchmarkFactory = new DefaultPlannerBenchmarkFactory(config);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((DefaultPlannerBenchmarkFactory)benchmarkFactory).generateSolverBenchmarkConfigNames());
    }

    @Test
    void uniqueNamesGenerated() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        SolverBenchmarkConfig sbc1 = new SolverBenchmarkConfig();
        SolverBenchmarkConfig sbc2 = new SolverBenchmarkConfig();
        SolverBenchmarkConfig sbc3 = new SolverBenchmarkConfig();
        sbc3.setName("Config_1");
        List<SolverBenchmarkConfig> configs = Arrays.asList(sbc1, sbc2, sbc3);
        config.setSolverBenchmarkConfigList(configs);
        DefaultPlannerBenchmarkFactory benchmarkFactory = new DefaultPlannerBenchmarkFactory(config);
        benchmarkFactory.generateSolverBenchmarkConfigNames();
        Assertions.assertThat((String)sbc3.getName()).isEqualTo("Config_1");
        TreeSet<String> names = new TreeSet<String>();
        for (SolverBenchmarkConfig sc : configs) {
            names.add(sc.getName());
        }
        for (int i = 0; i < configs.size(); ++i) {
            Assertions.assertThat(names).contains((Object[])new String[]{"Config_" + i});
        }
    }

    @Test
    void resolveParallelBenchmarkCountAutomatically() {
        DefaultPlannerBenchmarkFactory benchmarkFactory = new DefaultPlannerBenchmarkFactory(new PlannerBenchmarkConfig());
        Assertions.assertThat((int)benchmarkFactory.resolveParallelBenchmarkCountAutomatically(-1)).isEqualTo(1);
        Assertions.assertThat((int)benchmarkFactory.resolveParallelBenchmarkCountAutomatically(0)).isEqualTo(1);
        Assertions.assertThat((int)benchmarkFactory.resolveParallelBenchmarkCountAutomatically(1)).isEqualTo(1);
        Assertions.assertThat((int)benchmarkFactory.resolveParallelBenchmarkCountAutomatically(2)).isEqualTo(1);
        Assertions.assertThat((int)benchmarkFactory.resolveParallelBenchmarkCountAutomatically(3)).isEqualTo(2);
        Assertions.assertThat((int)benchmarkFactory.resolveParallelBenchmarkCountAutomatically(4)).isEqualTo(2);
        Assertions.assertThat((int)benchmarkFactory.resolveParallelBenchmarkCountAutomatically(5)).isEqualTo(3);
        Assertions.assertThat((int)benchmarkFactory.resolveParallelBenchmarkCountAutomatically(6)).isEqualTo(4);
        Assertions.assertThat((int)benchmarkFactory.resolveParallelBenchmarkCountAutomatically(17)).isEqualTo(9);
    }

    @Test
    void parallelBenchmarkDisabledByDefault() {
        DefaultPlannerBenchmarkFactory benchmarkFactory = new DefaultPlannerBenchmarkFactory(new PlannerBenchmarkConfig());
        Assertions.assertThat((int)benchmarkFactory.resolveParallelBenchmarkCount()).isEqualTo(1);
    }

    @Test
    void resolvedParallelBenchmarkCountNegative() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setParallelBenchmarkCount("-1");
        DefaultPlannerBenchmarkFactory benchmarkFactory = new DefaultPlannerBenchmarkFactory(config);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> ((DefaultPlannerBenchmarkFactory)benchmarkFactory).resolveParallelBenchmarkCount());
    }

    @Test
    void calculateWarmUpTimeMillisSpentLimit() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setWarmUpHoursSpentLimit(Long.valueOf(1L));
        config.setWarmUpMinutesSpentLimit(Long.valueOf(2L));
        config.setWarmUpSecondsSpentLimit(Long.valueOf(5L));
        config.setWarmUpMillisecondsSpentLimit(Long.valueOf(753L));
        DefaultPlannerBenchmarkFactory benchmarkFactory = new DefaultPlannerBenchmarkFactory(config);
        Assertions.assertThat((Long)benchmarkFactory.calculateWarmUpTimeMillisSpentLimit()).isEqualTo(3725753L);
    }
}

