/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.io.File;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.optaplanner.benchmark.api.PlannerBenchmarkException;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

class DefaultPlannerBenchmarkTest {
    DefaultPlannerBenchmarkTest() {
    }

    @Test
    void benchmarkingStartedTwice() {
        SolverConfig solverConfig = PlannerTestUtils.buildSolverConfig(TestdataSolution.class, (Class[])new Class[]{TestdataEntity.class});
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig));
        TestdataSolution solution = (TestdataSolution)Mockito.mock(TestdataSolution.class);
        DefaultPlannerBenchmark benchmark = (DefaultPlannerBenchmark)benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution});
        benchmark.benchmarkingStarted();
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> ((DefaultPlannerBenchmark)benchmark).benchmarkingStarted()).withNoCause();
    }

    @Test
    void solverBenchmarkResultListIsEmpty() {
        File benchmarkDirectory = (File)Mockito.mock(File.class);
        ExecutorService executorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        BenchmarkReport benchmarkReport = (BenchmarkReport)Mockito.mock(BenchmarkReport.class);
        PlannerBenchmarkResult benchmarkResult = new PlannerBenchmarkResult();
        DefaultPlannerBenchmark benchmark = new DefaultPlannerBenchmark(benchmarkResult, benchmarkDirectory, executorService, executorService, benchmarkReport);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ((DefaultPlannerBenchmark)benchmark).benchmarkingStarted()).withMessageContaining("solverBenchmarkResultList").withMessageContaining("empty");
    }

    @Test
    void benchmarkDirectoryIsNull() {
        ExecutorService executorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        BenchmarkReport benchmarkReport = (BenchmarkReport)Mockito.mock(BenchmarkReport.class);
        SolverBenchmarkResult benchmarkResult = (SolverBenchmarkResult)Mockito.mock(SolverBenchmarkResult.class);
        PlannerBenchmarkResult plannerBenchmarkResult = new PlannerBenchmarkResult();
        plannerBenchmarkResult.setSolverBenchmarkResultList(Collections.singletonList(benchmarkResult));
        DefaultPlannerBenchmark benchmark = new DefaultPlannerBenchmark(plannerBenchmarkResult, null, executorService, executorService, benchmarkReport);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ((DefaultPlannerBenchmark)benchmark).benchmarkingStarted()).withMessageContaining("benchmarkDirectory").withMessageContaining("null");
    }

    @Test
    void exceptionMessagePropagatesWhenThrownDuringWarmUp() {
        SolverConfig solverConfig = PlannerTestUtils.buildSolverConfig(TestdataSolution.class, (Class[])new Class[]{TestdataEntity.class});
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig));
        TestdataSolution solution = (TestdataSolution)Mockito.mock(TestdataSolution.class);
        UnsupportedOperationException exception = new UnsupportedOperationException();
        Mockito.when((Object)solution.getEntityList()).thenThrow(new Throwable[]{exception});
        DefaultPlannerBenchmark benchmark = (DefaultPlannerBenchmark)benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution});
        Assertions.assertThatExceptionOfType(PlannerBenchmarkException.class).isThrownBy(() -> ((DefaultPlannerBenchmark)benchmark).benchmark()).withCause((Throwable)exception);
    }
}

