/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedObject;

public class SelectorTestUtils {
    public static SolutionDescriptor mockSolutionDescriptor() {
        SolutionDescriptor solutionDescriptor = (SolutionDescriptor)Mockito.mock(SolutionDescriptor.class);
        return solutionDescriptor;
    }

    public static PlanningEntityDescriptor mockEntityDescriptor(Class entityClass) {
        PlanningEntityDescriptor entityDescriptor = (PlanningEntityDescriptor)Mockito.mock(PlanningEntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.getPlanningEntityClass()).thenReturn((Object)entityClass);
        return entityDescriptor;
    }

    public static PlanningVariableDescriptor mockVariableDescriptor(Class entityClass, String variableName) {
        PlanningEntityDescriptor entityDescriptor = SelectorTestUtils.mockEntityDescriptor(entityClass);
        return SelectorTestUtils.mockVariableDescriptor(entityDescriptor, variableName);
    }

    public static PlanningVariableDescriptor mockVariableDescriptor(PlanningEntityDescriptor entityDescriptor, String variableName) {
        PlanningVariableDescriptor variableDescriptor = (PlanningVariableDescriptor)Mockito.mock(PlanningVariableDescriptor.class);
        Mockito.when((Object)variableDescriptor.getPlanningEntityDescriptor()).thenReturn((Object)entityDescriptor);
        Mockito.when((Object)variableDescriptor.getVariableName()).thenReturn((Object)variableName);
        return variableDescriptor;
    }

    public static EntitySelector mockEntitySelector(Class entityClass, Object ... entities) {
        PlanningEntityDescriptor entityDescriptor = SelectorTestUtils.mockEntityDescriptor(entityClass);
        return SelectorTestUtils.mockEntitySelector(entityDescriptor, entities);
    }

    public static EntitySelector mockEntitySelector(PlanningEntityDescriptor entityDescriptor, Object ... entities) {
        EntitySelector entitySelector = (EntitySelector)Mockito.mock(EntitySelector.class);
        Mockito.when((Object)entitySelector.getEntityDescriptor()).thenReturn((Object)entityDescriptor);
        final List<Object> entityList = Arrays.asList(entities);
        Mockito.when((Object)entitySelector.iterator()).thenAnswer((Answer)new Answer<Iterator<Object>>(){

            public Iterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return entityList.iterator();
            }
        });
        Mockito.when((Object)entitySelector.listIterator()).thenAnswer((Answer)new Answer<ListIterator<Object>>(){

            public ListIterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return entityList.listIterator();
            }
        });
        int i = 0;
        while (i < entityList.size()) {
            final int index = i++;
            Mockito.when((Object)entitySelector.listIterator(index)).thenAnswer((Answer)new Answer<ListIterator<Object>>(){

                public ListIterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                    return entityList.listIterator(index);
                }
            });
        }
        Mockito.when((Object)entitySelector.isContinuous()).thenReturn((Object)false);
        Mockito.when((Object)entitySelector.isNeverEnding()).thenReturn((Object)false);
        Mockito.when((Object)entitySelector.getSize()).thenReturn((Object)entityList.size());
        return entitySelector;
    }

    public static ValueSelector mockValueSelector(Class entityClass, String variableName, Object ... values) {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(entityClass, variableName);
        return SelectorTestUtils.mockValueSelector(variableDescriptor, values);
    }

    public static ValueSelector mockValueSelector(PlanningEntityDescriptor entityDescriptor, String variableName, Object ... values) {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(entityDescriptor, variableName);
        return SelectorTestUtils.mockValueSelector(variableDescriptor, values);
    }

    public static ValueSelector mockValueSelector(PlanningVariableDescriptor variableDescriptor, Object ... values) {
        ValueSelector valueSelector = (ValueSelector)Mockito.mock(ValueSelector.class);
        Mockito.when((Object)valueSelector.getVariableDescriptor()).thenReturn((Object)variableDescriptor);
        final List<Object> valueList = Arrays.asList(values);
        Mockito.when((Object)valueSelector.iterator(Mockito.any())).thenAnswer((Answer)new Answer<Iterator<Object>>(){

            public Iterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return valueList.iterator();
            }
        });
        Mockito.when((Object)valueSelector.isContinuous()).thenReturn((Object)false);
        Mockito.when((Object)valueSelector.isNeverEnding()).thenReturn((Object)false);
        Mockito.when((Object)valueSelector.getSize(Mockito.any())).thenReturn((Object)valueList.size());
        return valueSelector;
    }

    public static EntityIndependentValueSelector mockEntityIndependentValueSelector(Class entityClass, String variableName, Object ... values) {
        PlanningVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(entityClass, variableName);
        return SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, values);
    }

    public static EntityIndependentValueSelector mockEntityIndependentValueSelector(PlanningVariableDescriptor variableDescriptor, Object ... values) {
        EntityIndependentValueSelector valueSelector = (EntityIndependentValueSelector)Mockito.mock(EntityIndependentValueSelector.class);
        Mockito.when((Object)valueSelector.getVariableDescriptor()).thenReturn((Object)variableDescriptor);
        final List<Object> valueList = Arrays.asList(values);
        Mockito.when((Object)valueSelector.iterator(Mockito.any())).thenAnswer((Answer)new Answer<Iterator<Object>>(){

            public Iterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return valueList.iterator();
            }
        });
        Mockito.when((Object)valueSelector.iterator()).thenAnswer((Answer)new Answer<Iterator<Object>>(){

            public Iterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return valueList.iterator();
            }
        });
        Mockito.when((Object)valueSelector.isContinuous()).thenReturn((Object)false);
        Mockito.when((Object)valueSelector.isNeverEnding()).thenReturn((Object)false);
        Mockito.when((Object)valueSelector.getSize(Mockito.any())).thenReturn((Object)valueList.size());
        Mockito.when((Object)valueSelector.getSize()).thenReturn((Object)valueList.size());
        return valueSelector;
    }

    public static MoveSelector mockMoveSelector(Class moveClass, Move ... moves) {
        MoveSelector moveSelector = (MoveSelector)Mockito.mock(MoveSelector.class);
        final List<Move> moveList = Arrays.asList(moves);
        Mockito.when((Object)moveSelector.iterator()).thenAnswer((Answer)new Answer<Iterator<Move>>(){

            public Iterator<Move> answer(InvocationOnMock invocation) throws Throwable {
                return moveList.iterator();
            }
        });
        Mockito.when((Object)moveSelector.isContinuous()).thenReturn((Object)false);
        Mockito.when((Object)moveSelector.isNeverEnding()).thenReturn((Object)false);
        Mockito.when((Object)moveSelector.getCacheType()).thenReturn((Object)SelectionCacheType.JUST_IN_TIME);
        Mockito.when((Object)moveSelector.getSize()).thenReturn((Object)moveList.size());
        return moveSelector;
    }

    public static void mockMethodGetTrailingEntity(ScoreDirector scoreDirector, PlanningVariableDescriptor variableDescriptor, final TestdataChainedEntity[] allEntities) {
        Mockito.when((Object)scoreDirector.getTrailingEntity((PlanningVariableDescriptor)Mockito.eq((Object)variableDescriptor), Mockito.anyObject())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object planningValue = invocation.getArguments()[1];
                for (TestdataChainedEntity entity : allEntities) {
                    if (!entity.getChainedObject().equals(planningValue)) continue;
                    return entity;
                }
                return null;
            }
        });
    }

    public static void assertChain(TestdataChainedObject ... chainedObjects) {
        TestdataChainedObject chainedObject = chainedObjects[0];
        for (int i = 1; i < chainedObjects.length; ++i) {
            TestdataChainedEntity chainedEntity = (TestdataChainedEntity)chainedObjects[i];
            Assert.assertEquals((String)("Chained entity (" + chainedEntity + ")'s chainedObject"), (Object)chainedObject, (Object)chainedEntity.getChainedObject());
            chainedObject = chainedEntity;
        }
    }

    private SelectorTestUtils() {
    }
}

