/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.tabu;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.PlanningEntityTabuAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;

public class PlanningEntityTabuAcceptorTest {
    @Test
    public void tabuSize() {
        PlanningEntityTabuAcceptor acceptor = new PlanningEntityTabuAcceptor();
        acceptor.setTabuSize(2);
        acceptor.setAspirationEnabled(true);
        TestdataEntity e0 = new TestdataEntity("e0");
        TestdataEntity e1 = new TestdataEntity("e1");
        TestdataEntity e2 = new TestdataEntity("e2");
        TestdataEntity e3 = new TestdataEntity("e3");
        TestdataEntity e4 = new TestdataEntity("e4");
        DefaultSolverScope solverScope = new DefaultSolverScope();
        solverScope.setBestScore((Score)SimpleScore.valueOf((int)0));
        LocalSearchSolverPhaseScope phaseScope = new LocalSearchSolverPhaseScope(solverScope);
        acceptor.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope0 = new LocalSearchStepScope(phaseScope);
        stepScope0.setStepIndex(0);
        LocalSearchMoveScope moveScope1 = this.buildMoveScope(stepScope0, e1);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e0)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope1));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e2)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e3)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e4)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e2)));
        stepScope0.setStep(moveScope1.getMove());
        acceptor.stepEnded(stepScope0);
        LocalSearchStepScope stepScope1 = new LocalSearchStepScope(phaseScope);
        stepScope1.setStepIndex(1);
        LocalSearchMoveScope moveScope2 = this.buildMoveScope(stepScope1, e2);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e0)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e1)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope2));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e3)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e4)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e2)));
        stepScope1.setStep(moveScope2.getMove());
        acceptor.stepEnded(stepScope1);
        LocalSearchStepScope stepScope2 = new LocalSearchStepScope(phaseScope);
        stepScope2.setStepIndex(2);
        LocalSearchMoveScope moveScope4 = this.buildMoveScope(stepScope2, e4);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e0)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e1)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e2)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e3)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope4));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e2)));
        stepScope2.setStep(moveScope4.getMove());
        acceptor.stepEnded(stepScope2);
        LocalSearchStepScope stepScope3 = new LocalSearchStepScope(phaseScope);
        stepScope3.setStepIndex(3);
        LocalSearchMoveScope moveScope3 = this.buildMoveScope(stepScope3, e3);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e0)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e1)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e2)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope3));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e4)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e2)));
        stepScope3.setStep(moveScope3.getMove());
        acceptor.stepEnded(stepScope3);
        LocalSearchStepScope stepScope4 = new LocalSearchStepScope(phaseScope);
        stepScope4.setStepIndex(4);
        LocalSearchMoveScope moveScope1Again = this.buildMoveScope(stepScope4, e1);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, e0)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope1Again));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, e2)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, e3)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, e4)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, e2)));
        stepScope4.setStep(moveScope1Again.getMove());
        acceptor.stepEnded(stepScope4);
        acceptor.phaseEnded(phaseScope);
    }

    @Test
    public void tabuSizeMultipleEntitiesPerStep() {
        PlanningEntityTabuAcceptor acceptor = new PlanningEntityTabuAcceptor();
        acceptor.setTabuSize(2);
        acceptor.setAspirationEnabled(true);
        TestdataEntity e0 = new TestdataEntity("e0");
        TestdataEntity e1 = new TestdataEntity("e1");
        TestdataEntity e2 = new TestdataEntity("e2");
        TestdataEntity e3 = new TestdataEntity("e3");
        TestdataEntity e4 = new TestdataEntity("e4");
        DefaultSolverScope solverScope = new DefaultSolverScope();
        solverScope.setBestScore((Score)SimpleScore.valueOf((int)0));
        LocalSearchSolverPhaseScope phaseScope = new LocalSearchSolverPhaseScope(solverScope);
        acceptor.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope0 = new LocalSearchStepScope(phaseScope);
        stepScope0.setStepIndex(0);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e0)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e1)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e2)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e3)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e4)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e0, e1)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e0, e2)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e0, e3)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e0, e4)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e1, e2)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e1, e3)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e1, e4)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e2, e3)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e2, e4)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, e3, e4)));
        stepScope0.setStep(this.buildMoveScope(stepScope0, e0, e2).getMove());
        acceptor.stepEnded(stepScope0);
        LocalSearchStepScope stepScope1 = new LocalSearchStepScope(phaseScope);
        stepScope1.setStepIndex(1);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e0)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e1)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e2)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e3)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e4)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e0, e1)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e0, e2)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e0, e3)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e0, e4)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e1, e2)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e1, e3)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e1, e4)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e2, e3)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e2, e4)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, e3, e4)));
        stepScope1.setStep(this.buildMoveScope(stepScope1, e1).getMove());
        acceptor.stepEnded(stepScope1);
        LocalSearchStepScope stepScope2 = new LocalSearchStepScope(phaseScope);
        stepScope2.setStepIndex(2);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e0)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e1)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e2)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e3)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e4)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e0, e1)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e0, e2)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e0, e3)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e0, e4)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e1, e2)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e1, e3)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e1, e4)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e2, e3)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e2, e4)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, e3, e4)));
        stepScope2.setStep(this.buildMoveScope(stepScope2, e3, e4).getMove());
        acceptor.stepEnded(stepScope2);
        LocalSearchStepScope stepScope3 = new LocalSearchStepScope(phaseScope);
        stepScope3.setStepIndex(3);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e0)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e1)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e2)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e3)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e4)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e0, e1)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e0, e2)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e0, e3)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e0, e4)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e1, e2)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e1, e3)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e1, e4)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e2, e3)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e2, e4)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, e3, e4)));
        stepScope3.setStep(this.buildMoveScope(stepScope3, e0).getMove());
        acceptor.stepEnded(stepScope3);
        acceptor.phaseEnded(phaseScope);
    }

    @Test
    public void aspiration() {
        PlanningEntityTabuAcceptor acceptor = new PlanningEntityTabuAcceptor();
        acceptor.setTabuSize(2);
        acceptor.setAspirationEnabled(true);
        TestdataEntity e0 = new TestdataEntity("e0");
        TestdataEntity e1 = new TestdataEntity("e1");
        DefaultSolverScope solverScope = new DefaultSolverScope();
        solverScope.setBestScore((Score)SimpleScore.valueOf((int)-100));
        LocalSearchSolverPhaseScope phaseScope = new LocalSearchSolverPhaseScope(solverScope);
        acceptor.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope0 = new LocalSearchStepScope(phaseScope);
        stepScope0.setStepIndex(0);
        stepScope0.setStep(this.buildMoveScope(stepScope0, e1).getMove());
        acceptor.stepEnded(stepScope0);
        LocalSearchStepScope stepScope1 = new LocalSearchStepScope(phaseScope);
        stepScope1.setStepIndex(1);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -120, e0)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -20, e0)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -120, e1)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -20, e1)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -120, e0, e1)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -20, e0, e1)));
        stepScope1.setStep(this.buildMoveScope(stepScope1, -20, e1).getMove());
        acceptor.stepEnded(stepScope1);
        acceptor.phaseEnded(phaseScope);
    }

    private LocalSearchMoveScope buildMoveScope(LocalSearchStepScope stepScope, TestdataEntity ... entities) {
        return this.buildMoveScope(stepScope, 0, entities);
    }

    private LocalSearchMoveScope buildMoveScope(LocalSearchStepScope stepScope, int score, TestdataEntity ... entities) {
        LocalSearchMoveScope moveScope = new LocalSearchMoveScope(stepScope);
        Move move = (Move)Mockito.mock(Move.class);
        Mockito.when((Object)move.getPlanningEntities()).thenReturn(Arrays.asList(entities));
        moveScope.setMove(move);
        moveScope.setScore((Score)SimpleScore.valueOf((int)score));
        return moveScope;
    }
}

