/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardSoftBigDecimalScoreHolder
extends AbstractScoreHolder {
    protected BigDecimal hardScore;
    protected BigDecimal softScore;

    public HardSoftBigDecimalScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public void setHardScore(BigDecimal hardScore) {
        this.hardScore = hardScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    public void setSoftScore(BigDecimal softScore) {
        this.softScore = softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, final BigDecimal weight) {
        this.hardScore = this.hardScore.add(weight);
        this.registerBigDecimalConstraintMatch(kcontext, 0, weight, new Runnable(){

            @Override
            public void run() {
                HardSoftBigDecimalScoreHolder.this.hardScore = HardSoftBigDecimalScoreHolder.this.hardScore.subtract(weight);
            }
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, final BigDecimal weight) {
        this.softScore = this.softScore.add(weight);
        this.registerBigDecimalConstraintMatch(kcontext, 1, weight, new Runnable(){

            @Override
            public void run() {
                HardSoftBigDecimalScoreHolder.this.softScore = HardSoftBigDecimalScoreHolder.this.softScore.subtract(weight);
            }
        });
    }

    @Override
    public Score extractScore() {
        return HardSoftBigDecimalScore.valueOf(this.hardScore, this.softScore);
    }
}

