/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simple;

import org.optaplanner.core.api.score.AbstractScore;

public final class SimpleScore
extends AbstractScore<SimpleScore> {
    private final int score;

    public static SimpleScore parseScore(String scoreString) {
        return SimpleScore.valueOf(Integer.parseInt(scoreString));
    }

    public static SimpleScore valueOf(int score) {
        return new SimpleScore(score);
    }

    private SimpleScore(int score) {
        this.score = score;
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public SimpleScore add(SimpleScore augment) {
        return new SimpleScore(this.score + augment.getScore());
    }

    @Override
    public SimpleScore subtract(SimpleScore subtrahend) {
        return new SimpleScore(this.score - subtrahend.getScore());
    }

    @Override
    public SimpleScore multiply(double multiplicand) {
        return new SimpleScore((int)Math.floor((double)this.score * multiplicand));
    }

    @Override
    public SimpleScore divide(double divisor) {
        return new SimpleScore((int)Math.floor((double)this.score / divisor));
    }

    @Override
    public double[] toDoubleLevels() {
        return new double[]{this.score};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleScore) {
            SimpleScore other = (SimpleScore)o;
            return this.score == other.getScore();
        }
        return false;
    }

    public int hashCode() {
        return 629 + this.score;
    }

    @Override
    public int compareTo(SimpleScore other) {
        if (this.score < other.getScore()) {
            return -1;
        }
        if (this.score > other.getScore()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return Integer.toString(this.score);
    }
}

