/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.move.factory;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveListFactory;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveListFactoryToMoveSelectorBridge;

@XStreamAlias(value="moveListFactory")
public class MoveListFactoryConfig
extends MoveSelectorConfig {
    protected Class<? extends MoveListFactory> moveListFactoryClass = null;

    public Class<? extends MoveListFactory> getMoveListFactoryClass() {
        return this.moveListFactoryClass;
    }

    public void setMoveListFactoryClass(Class<? extends MoveListFactory> moveListFactoryClass) {
        this.moveListFactoryClass = moveListFactoryClass;
    }

    @Override
    protected boolean isBaseInherentlyCached() {
        return true;
    }

    @Override
    public MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        MoveListFactory moveListFactory = ConfigUtils.newInstance(this, "moveListFactoryClass", this.moveListFactoryClass);
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) < 0) {
            minimumCacheType = SelectionCacheType.STEP;
        }
        return new MoveListFactoryToMoveSelectorBridge(moveListFactory, minimumCacheType, randomSelection);
    }

    public void inherit(MoveListFactoryConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.moveListFactoryClass = ConfigUtils.inheritOverwritableProperty(this.moveListFactoryClass, inheritedConfig.getMoveListFactoryClass());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.moveListFactoryClass + ")";
    }
}

