/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.composite;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections.IteratorUtils;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.composite.CompositeMoveSelector;
import org.optaplanner.core.impl.move.CompositeMove;
import org.optaplanner.core.impl.move.Move;

public class CartesianProductMoveSelector
extends CompositeMoveSelector {
    public CartesianProductMoveSelector(List<MoveSelector> childMoveSelectorList, boolean randomSelection) {
        super(childMoveSelectorList, randomSelection);
    }

    @Override
    public boolean isNeverEnding() {
        if (this.randomSelection) {
            return true;
        }
        return !this.childMoveSelectorList.isEmpty() && ((MoveSelector)this.childMoveSelectorList.get(this.childMoveSelectorList.size() - 1)).isNeverEnding();
    }

    @Override
    public long getSize() {
        long size = 1L;
        for (MoveSelector moveSelector : this.childMoveSelectorList) {
            size *= moveSelector.getSize();
        }
        return size;
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new OriginalCartesianProductMoveIterator();
        }
        return new RandomCartesianProductMoveIterator();
    }

    @Override
    public String toString() {
        return "CartesianProduct(" + this.childMoveSelectorList + ")";
    }

    public class RandomCartesianProductMoveIterator
    implements Iterator<Move> {
        private List<Iterator<Move>> moveIteratorList;
        private boolean empty;

        public RandomCartesianProductMoveIterator() {
            this.moveIteratorList = new ArrayList<Iterator<Move>>(CartesianProductMoveSelector.this.childMoveSelectorList.size());
            this.empty = false;
            for (MoveSelector moveSelector : CartesianProductMoveSelector.this.childMoveSelectorList) {
                Iterator moveIterator = moveSelector.iterator();
                if (!moveIterator.hasNext()) {
                    this.empty = true;
                }
                this.moveIteratorList.add(moveIterator);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.empty;
        }

        @Override
        public Move next() {
            ArrayList<Move> moveList = new ArrayList<Move>(this.moveIteratorList.size());
            for (int i = 0; i < this.moveIteratorList.size(); ++i) {
                Iterator<Move> moveIterator = this.moveIteratorList.get(i);
                if (!moveIterator.hasNext()) {
                    MoveSelector moveSelector = (MoveSelector)CartesianProductMoveSelector.this.childMoveSelectorList.get(i);
                    moveIterator = moveSelector.iterator();
                    this.moveIteratorList.set(i, moveIterator);
                    if (!moveIterator.hasNext()) {
                        throw new NoSuchElementException("The moveSelector (" + moveSelector + ") is empty.");
                    }
                }
                moveList.add(moveIterator.next());
            }
            return new CompositeMove(moveList);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }
    }

    public class OriginalCartesianProductMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private List<Iterator<Move>> moveIteratorList;
        private List<Move> subSelections;

        public OriginalCartesianProductMoveIterator() {
            this.moveIteratorList = new ArrayList<Iterator<Move>>(CartesianProductMoveSelector.this.childMoveSelectorList.size());
            this.subSelections = new ArrayList<Move>(CartesianProductMoveSelector.this.childMoveSelectorList.size());
            for (int i = 0; i < CartesianProductMoveSelector.this.childMoveSelectorList.size(); ++i) {
                if (i == 0) {
                    this.moveIteratorList.add(((MoveSelector)CartesianProductMoveSelector.this.childMoveSelectorList.get(i)).iterator());
                } else {
                    this.moveIteratorList.add((Iterator<Move>)IteratorUtils.emptyListIterator());
                }
                this.subSelections.add(null);
            }
            this.createUpcomingSelection();
        }

        @Override
        protected void createUpcomingSelection() {
            ArrayList<Move> moveList = new ArrayList<Move>(this.subSelections);
            for (int i = this.moveIteratorList.size() - 1; i >= 0; --i) {
                Iterator<Move> moveIterator = this.moveIteratorList.get(i);
                if (moveIterator.hasNext()) {
                    moveList.set(i, moveIterator.next());
                    break;
                }
                if (i == 0) {
                    this.upcomingSelection = null;
                    return;
                }
                moveIterator = ((MoveSelector)CartesianProductMoveSelector.this.childMoveSelectorList.get(i)).iterator();
                this.moveIteratorList.set(i, moveIterator);
                if (!moveIterator.hasNext()) {
                    this.upcomingSelection = null;
                    return;
                }
                moveList.set(i, moveIterator.next());
            }
            this.subSelections = moveList;
            this.upcomingSelection = new CompositeMove(moveList);
        }
    }
}

