/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.IterableSelector;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.move.Move;

public class ChangeMoveSelector
extends GenericMoveSelector {
    protected final EntitySelector entitySelector;
    protected final ValueSelector valueSelector;
    protected final boolean randomSelection;
    protected final boolean chained;

    public ChangeMoveSelector(EntitySelector entitySelector, ValueSelector valueSelector, boolean randomSelection) {
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        PlanningVariableDescriptor variableDescriptor = valueSelector.getVariableDescriptor();
        this.chained = variableDescriptor.isChained();
        this.solverPhaseLifecycleSupport.addEventListener(entitySelector);
        this.solverPhaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public boolean isContinuous() {
        return this.entitySelector.isContinuous() || this.valueSelector.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.entitySelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        if (this.valueSelector instanceof IterableSelector) {
            return this.entitySelector.getSize() * ((IterableSelector)((Object)this.valueSelector)).getSize();
        }
        long size = 0L;
        for (Object entity : this.entitySelector) {
            size += this.valueSelector.getSize(entity);
        }
        return size;
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new OriginalChangeMoveIterator();
        }
        return new RandomChangeMoveIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ", " + this.valueSelector + ")";
    }

    private class RandomChangeMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private Iterator<Object> entityIterator;
        private Iterator<Object> valueIterator = null;

        private RandomChangeMoveIterator() {
            this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
            if (!this.entityIterator.hasNext()) {
                this.upcomingSelection = null;
            } else {
                this.createUpcomingSelection();
            }
        }

        @Override
        protected void createUpcomingSelection() {
            if (!this.entityIterator.hasNext()) {
                this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
            }
            Object entity = this.entityIterator.next();
            this.valueIterator = ChangeMoveSelector.this.valueSelector.iterator(entity);
            int entityIteratorCreationCount = 0;
            while (!this.valueIterator.hasNext()) {
                if (!this.entityIterator.hasNext()) {
                    this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
                    if (++entityIteratorCreationCount >= 2) {
                        this.upcomingSelection = null;
                        return;
                    }
                }
                entity = this.entityIterator.next();
                this.valueIterator = ChangeMoveSelector.this.valueSelector.iterator(entity);
            }
            Object toValue = this.valueIterator.next();
            this.upcomingSelection = ChangeMoveSelector.this.chained ? new ChainedChangeMove(entity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue) : new ChangeMove(entity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
        }
    }

    private class OriginalChangeMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private Iterator<Object> entityIterator;
        private Iterator<Object> valueIterator;
        private Object upcomingEntity;

        private OriginalChangeMoveIterator() {
            this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
            if (!this.entityIterator.hasNext()) {
                this.upcomingSelection = null;
            } else {
                this.upcomingEntity = this.entityIterator.next();
                this.valueIterator = ChangeMoveSelector.this.valueSelector.iterator(this.upcomingEntity);
                this.createUpcomingSelection();
            }
        }

        @Override
        protected void createUpcomingSelection() {
            while (!this.valueIterator.hasNext()) {
                if (!this.entityIterator.hasNext()) {
                    this.upcomingSelection = null;
                    return;
                }
                this.upcomingEntity = this.entityIterator.next();
                this.valueIterator = ChangeMoveSelector.this.valueSelector.iterator(this.upcomingEntity);
            }
            Object toValue = this.valueIterator.next();
            this.upcomingSelection = ChangeMoveSelector.this.chained ? new ChainedChangeMove(this.upcomingEntity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue) : new ChangeMove(this.upcomingEntity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
        }
    }
}

